/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3._private;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.ToIntFunction;
import org.jboss.remoting3._private.Equaller;
import org.jboss.remoting3._private.IntIndexMap;

public final class IntIndexHashMap<V>
extends AbstractCollection<V>
implements IntIndexMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 512;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.6f;
    private static final Object[] RESIZED = new Object[0];
    private static final Object NONEXISTENT = new Object();
    private final ToIntFunction<? super V> indexer;
    private final Equaller<? super V> ve;
    private volatile Table<V> table;
    private final float loadFactor;
    private final int initialCapacity;
    private static final AtomicIntegerFieldUpdater<Table> sizeUpdater = AtomicIntegerFieldUpdater.newUpdater(Table.class, "size");
    private static final AtomicReferenceFieldUpdater<IntIndexHashMap, Table> tableUpdater = AtomicReferenceFieldUpdater.newUpdater(IntIndexHashMap.class, Table.class, "table");

    public IntIndexHashMap(ToIntFunction<? super V> indexer, Equaller<? super V> valueEqualler, int initialCapacity, float loadFactor) {
        int capacity;
        if (valueEqualler == null) {
            throw new IllegalArgumentException("valueEqualler is null");
        }
        this.indexer = indexer;
        this.ve = valueEqualler;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be > 0");
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if ((double)loadFactor <= 0.0 || Float.isNaN(loadFactor) || (double)loadFactor >= 1.0) {
            throw new IllegalArgumentException("Load factor must be between 0.0f and 1.0f");
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.initialCapacity = capacity;
        Table table = new Table(capacity, loadFactor);
        tableUpdater.set(this, table);
    }

    public IntIndexHashMap(ToIntFunction<? super V> indexer, Equaller<? super V> valueEqualler) {
        this(indexer, valueEqualler, 512, 0.6f);
    }

    public IntIndexHashMap(ToIntFunction<? super V> indexer, int initialCapacity, float loadFactor) {
        this(indexer, Equaller.DEFAULT, initialCapacity, loadFactor);
    }

    public IntIndexHashMap(ToIntFunction<? super V> indexer, float loadFactor) {
        this(indexer, 512, loadFactor);
    }

    public IntIndexHashMap(ToIntFunction<? super V> indexer, int initialCapacity) {
        this(indexer, initialCapacity, 0.6f);
    }

    public IntIndexHashMap(ToIntFunction<? super V> indexer) {
        this(indexer, 512, 0.6f);
    }

    @Override
    public V putIfAbsent(V value) {
        V result = this.doPut(value, true, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    @Override
    public V removeKey(int index) {
        V result = this.doRemove(index, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    @Override
    public boolean remove(Object value) {
        return this.doRemove(value, this.table);
    }

    @Override
    public boolean containsKey(int index) {
        return this.doGet(this.table, index) != NONEXISTENT;
    }

    @Override
    public V get(int index) {
        V result = this.doGet(this.table, index);
        return result == NONEXISTENT ? null : (V)result;
    }

    @Override
    public V put(V value) {
        V result = this.doPut(value, false, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    @Override
    public V replace(V value) {
        V result = this.doReplace(value, this.table);
        return result == NONEXISTENT ? null : (V)result;
    }

    @Override
    public boolean replace(V oldValue, V newValue) {
        if (this.indexer.applyAsInt(oldValue) != this.indexer.applyAsInt(newValue)) {
            throw new IllegalArgumentException("Can only replace with value which has the same key");
        }
        return this.doReplace(oldValue, newValue, this.table);
    }

    @Override
    public int applyAsInt(V argument) {
        return this.indexer.applyAsInt(argument);
    }

    @Override
    public boolean add(V v) {
        return this.doPut(v, true, this.table) == NONEXISTENT;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<V> list = new ArrayList<V>(this.size());
        for (V item : this) {
            list.add(item);
        }
        return list.toArray(a);
    }

    @Override
    public Object[] toArray() {
        ArrayList<V> list = new ArrayList<V>(this.size());
        for (V item : this) {
            list.add(item);
        }
        return list.toArray();
    }

    @Override
    public boolean contains(Object o) {
        return this.ve.equals(o, this.get(this.indexer.applyAsInt(o)));
    }

    @Override
    public Iterator<V> iterator() {
        return new EntryIterator();
    }

    @Override
    public int size() {
        return this.table.size & Integer.MAX_VALUE;
    }

    private boolean doReplace(V oldValue, V newValue, Table<V> table) {
        int key = this.indexer.applyAsInt(oldValue);
        AtomicReferenceArray<V[]> array = table.array;
        int idx = key & array.length() - 1;
        block0: while (true) {
            V[] oldRow;
            if ((oldRow = array.get(idx)) == null) {
                return false;
            }
            if (oldRow == RESIZED) {
                return this.doReplace(oldValue, newValue, table.resizeView);
            }
            int length = oldRow.length;
            for (int i = 0; i < length; ++i) {
                Object tryItem = oldRow[i];
                if (!this.ve.equals(tryItem, oldValue)) continue;
                Object[] newRow = (Object[])oldRow.clone();
                newRow[i] = newValue;
                if (!array.compareAndSet(i, oldRow, newRow)) continue block0;
                return true;
            }
            break;
        }
        return false;
    }

    private V doReplace(V value, Table<V> table) {
        int key = this.indexer.applyAsInt(value);
        AtomicReferenceArray<V[]> array = table.array;
        int idx = key & array.length() - 1;
        block0: while (true) {
            V[] oldRow;
            if ((oldRow = array.get(idx)) == null) {
                return IntIndexHashMap.nonexistent();
            }
            if (oldRow == RESIZED) {
                return this.doReplace(value, table.resizeView);
            }
            int length = oldRow.length;
            for (int i = 0; i < length; ++i) {
                Object tryItem = oldRow[i];
                if (key != this.indexer.applyAsInt(tryItem)) continue;
                Object[] newRow = (Object[])oldRow.clone();
                newRow[i] = value;
                if (!array.compareAndSet(i, oldRow, newRow)) continue block0;
                return tryItem;
            }
            break;
        }
        return IntIndexHashMap.nonexistent();
    }

    private boolean doRemove(V item, Table<V> table) {
        int key = this.indexer.applyAsInt(item);
        AtomicReferenceArray<V[]> array = table.array;
        int idx = key & array.length() - 1;
        block0: while (true) {
            V[] oldRow;
            if ((oldRow = array.get(idx)) == null) {
                return false;
            }
            if (oldRow == RESIZED) {
                boolean result = this.doRemove(item, table.resizeView);
                if (result) {
                    sizeUpdater.getAndDecrement(table);
                }
                return result;
            }
            for (int i = 0; i < oldRow.length; ++i) {
                if (!this.ve.equals(item, oldRow[i])) continue;
                if (!array.compareAndSet(idx, oldRow, IntIndexHashMap.remove(oldRow, i))) continue block0;
                sizeUpdater.getAndDecrement(table);
                return true;
            }
            break;
        }
        return false;
    }

    private V doRemove(int key, Table<V> table) {
        AtomicReferenceArray<V[]> array = table.array;
        int idx = key & array.length() - 1;
        block0: while (true) {
            V[] oldRow;
            if ((oldRow = array.get(idx)) == null) {
                return IntIndexHashMap.nonexistent();
            }
            if (oldRow == RESIZED) {
                Object result = this.doRemove(key, table.resizeView);
                if (result != NONEXISTENT) {
                    sizeUpdater.getAndDecrement(table);
                }
                return result;
            }
            for (int i = 0; i < oldRow.length; ++i) {
                if (key != this.indexer.applyAsInt(oldRow[i])) continue;
                if (!array.compareAndSet(idx, oldRow, IntIndexHashMap.remove(oldRow, i))) continue block0;
                sizeUpdater.getAndDecrement(table);
                return oldRow[i];
            }
            break;
        }
        return IntIndexHashMap.nonexistent();
    }

    private V doPut(V value, boolean ifAbsent, Table<V> table) {
        int hashCode = this.indexer.applyAsInt(value);
        AtomicReferenceArray<V[]> array = table.array;
        int idx = hashCode & array.length() - 1;
        block0: while (true) {
            V[] oldRow;
            if ((oldRow = array.get(idx)) == RESIZED) {
                V result = this.doPut(value, ifAbsent, table.resizeView);
                if (result == NONEXISTENT) {
                    sizeUpdater.getAndIncrement(table);
                }
                return result;
            }
            if (oldRow != null) {
                int length = oldRow.length;
                for (int i = 0; i < length; ++i) {
                    if (hashCode != this.indexer.applyAsInt(oldRow[i])) continue;
                    if (ifAbsent) {
                        return oldRow[i];
                    }
                    Object[] newRow = (Object[])oldRow.clone();
                    newRow[i] = value;
                    Object oldItem = oldRow[i];
                    if (!array.compareAndSet(idx, oldRow, newRow)) continue block0;
                    return oldItem;
                }
            }
            if (array.compareAndSet(idx, oldRow, IntIndexHashMap.addItem(oldRow, value))) break;
        }
        int threshold = table.threshold;
        int newSize = sizeUpdater.incrementAndGet(table);
        while (newSize > threshold) {
            if (sizeUpdater.compareAndSet(table, newSize, newSize | Integer.MIN_VALUE)) {
                this.resize(table);
                break;
            }
            newSize = table.size;
        }
        return IntIndexHashMap.nonexistent();
    }

    private void resize(Table<V> origTable) {
        int size;
        AtomicReferenceArray<V[]> origArray = origTable.array;
        int origCapacity = origArray.length();
        Table newTable = new Table(origCapacity << 1, this.loadFactor);
        newTable.size = Integer.MIN_VALUE;
        origTable.resizeView = newTable;
        AtomicReferenceArray<V[]> newArray = newTable.array;
        for (int i = 0; i < origCapacity; ++i) {
            V[] origRow;
            int count0 = 0;
            int count1 = 0;
            do {
                if ((origRow = origArray.get(i)) == null) continue;
                for (Object item : origRow) {
                    if ((this.indexer.applyAsInt(item) & origCapacity) == 0) {
                        ++count0;
                        continue;
                    }
                    ++count1;
                }
                if (count0 != 0) {
                    V[] newRow0 = IntIndexHashMap.createRow(count0);
                    int j = 0;
                    for (Object item : origRow) {
                        if ((this.indexer.applyAsInt(item) & origCapacity) != 0) continue;
                        newRow0[j++] = item;
                    }
                    newArray.lazySet(i, newRow0);
                }
                if (count1 == 0) continue;
                V[] newRow1 = IntIndexHashMap.createRow(count1);
                int j = 0;
                for (Object item : origRow) {
                    if ((this.indexer.applyAsInt(item) & origCapacity) == 0) continue;
                    newRow1[j++] = item;
                }
                newArray.lazySet(i + origCapacity, newRow1);
            } while (!origArray.compareAndSet(i, origRow, IntIndexHashMap.resized()));
            sizeUpdater.getAndAdd(newTable, count0 + count1);
        }
        do {
            if (((size = newTable.size) & Integer.MAX_VALUE) < newTable.threshold) continue;
            this.table = newTable;
            this.resize(newTable);
            return;
        } while (!sizeUpdater.compareAndSet(newTable, size, size & Integer.MAX_VALUE));
        this.table = newTable;
    }

    private static <V> V[] remove(V[] row, int idx) {
        int len = row.length;
        assert (idx < len);
        if (len == 1) {
            return null;
        }
        V[] newRow = IntIndexHashMap.createRow(len - 1);
        if (idx > 0) {
            System.arraycopy(row, 0, newRow, 0, idx);
        }
        if (idx < len - 1) {
            System.arraycopy(row, idx + 1, newRow, idx, len - 1 - idx);
        }
        return newRow;
    }

    private V doGet(Table<V> table, int key) {
        AtomicReferenceArray<V[]> array = table.array;
        V[] row = array.get(key & array.length() - 1);
        if (row != null) {
            for (Object item : row) {
                if (key != this.indexer.applyAsInt(item)) continue;
                return item;
            }
        }
        return IntIndexHashMap.nonexistent();
    }

    @Override
    public void clear() {
        this.table = new Table(this.initialCapacity, this.loadFactor);
    }

    private static <V> V[] addItem(V[] row, V newItem) {
        if (row == null) {
            return IntIndexHashMap.createRow(newItem);
        }
        int length = row.length;
        V[] newRow = Arrays.copyOf(row, length + 1);
        newRow[length] = newItem;
        return newRow;
    }

    private static <V> V[] createRow(V newItem) {
        return new Object[]{newItem};
    }

    private static <V> V[] createRow(int length) {
        return new Object[length];
    }

    private static <V> V nonexistent() {
        return (V)NONEXISTENT;
    }

    private static <V> V[] resized() {
        return RESIZED;
    }

    private Iterator<V> createRowIterator(Table<V> table, int rowIdx) {
        AtomicReferenceArray<V[]> array = table.array;
        V[] row = array.get(rowIdx);
        if (row == RESIZED) {
            Table resizeView = table.resizeView;
            return new BranchIterator(this.createRowIterator(resizeView, rowIdx), this.createRowIterator(resizeView, rowIdx + array.length()));
        }
        return new RowIterator(table, row);
    }

    static final class Table<V> {
        final AtomicReferenceArray<V[]> array;
        final int threshold;
        volatile int size;
        volatile Table<V> resizeView;

        private Table(int capacity, float loadFactor) {
            this.array = new AtomicReferenceArray(capacity);
            this.threshold = capacity == 0x40000000 ? Integer.MAX_VALUE : (int)((float)capacity * loadFactor);
        }
    }

    final class EntryIterator
    implements Iterator<V> {
        private final Table<V> table;
        private Iterator<V> tableIterator;
        private Iterator<V> removeIterator;
        private int tableIdx;
        private V next;

        EntryIterator() {
            this.table = IntIndexHashMap.this.table;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (this.tableIdx == this.table.array.length()) {
                    return false;
                }
                if (this.tableIterator == null) {
                    this.tableIterator = IntIndexHashMap.this.createRowIterator(this.table, this.tableIdx++);
                }
                if (this.tableIterator.hasNext()) {
                    this.next = this.tableIterator.next();
                    return true;
                }
                this.tableIterator = null;
            }
            return true;
        }

        @Override
        public V next() {
            if (this.hasNext()) {
                try {
                    Object v = this.next;
                    return v;
                }
                finally {
                    this.removeIterator = this.tableIterator;
                    this.next = null;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            Iterator removeIterator = this.removeIterator;
            if (removeIterator == null) {
                throw new IllegalStateException();
            }
            try {
                removeIterator.remove();
            }
            finally {
                this.removeIterator = null;
            }
        }
    }

    final class BranchIterator
    implements Iterator<V> {
        private final Iterator<V> branch0;
        private final Iterator<V> branch1;
        private boolean branch;

        BranchIterator(Iterator<V> branch0, Iterator<V> branch1) {
            this.branch0 = branch0;
            this.branch1 = branch1;
        }

        @Override
        public boolean hasNext() {
            return this.branch0.hasNext() || this.branch1.hasNext();
        }

        @Override
        public V next() {
            if (this.branch) {
                return this.branch1.next();
            }
            if (this.branch0.hasNext()) {
                return this.branch0.next();
            }
            this.branch = true;
            return this.branch1.next();
        }

        @Override
        public void remove() {
            if (this.branch) {
                this.branch0.remove();
            } else {
                this.branch1.remove();
            }
        }
    }

    final class RowIterator
    implements Iterator<V> {
        private final Table<V> table;
        V[] row;
        private int idx;
        private int removeIdx = -1;
        private V next = IntIndexHashMap.access$100();

        RowIterator(Table<V> table, V[] row) {
            this.table = table;
            this.row = row;
        }

        @Override
        public boolean hasNext() {
            while (this.next == NONEXISTENT) {
                V[] row = this.row;
                if (row == null || this.idx == row.length) {
                    return false;
                }
                this.next = row[this.idx++];
            }
            return true;
        }

        @Override
        public V next() {
            if (this.hasNext()) {
                try {
                    this.removeIdx = this.idx - 1;
                    Object v = this.next;
                    return v;
                }
                finally {
                    this.next = IntIndexHashMap.nonexistent();
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            int removeIdx = this.removeIdx;
            this.removeIdx = -1;
            if (removeIdx == -1) {
                throw new IllegalStateException("next() not yet called");
            }
            IntIndexHashMap.this.doRemove(this.row[removeIdx], this.table);
        }
    }
}

