/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Collections;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;

public interface ModifiableRealmIdentity
extends RealmIdentity {
    public static final ModifiableRealmIdentity NON_EXISTENT = new ModifiableRealmIdentity(){

        @Override
        public Principal getRealmIdentityPrincipal() {
            return null;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidenceType", evidenceType);
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"credentialType", credentialType);
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            Assert.checkNotNullParam((String)"evidence", (Object)evidence);
            return false;
        }

        @Override
        public boolean exists() throws RealmUnavailableException {
            return false;
        }

        @Override
        public void delete() throws RealmUnavailableException {
        }

        @Override
        public void create() throws RealmUnavailableException {
            throw ElytronMessages.log.unableToCreateIdentity();
        }

        @Override
        public void setCredentials(Collection<? extends Credential> credentials) throws RealmUnavailableException {
            throw ElytronMessages.log.noSuchIdentity();
        }

        @Override
        public void setAttributes(Attributes attributes) throws RealmUnavailableException {
            throw ElytronMessages.log.noSuchIdentity();
        }
    };

    public void delete() throws RealmUnavailableException;

    public void create() throws RealmUnavailableException;

    public void setCredentials(Collection<? extends Credential> var1) throws RealmUnavailableException;

    @Override
    default public void updateCredential(Credential credential) throws RealmUnavailableException {
        this.setCredentials(Collections.singletonList(credential));
    }

    public void setAttributes(Attributes var1) throws RealmUnavailableException;
}

