/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.cli;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;
import org.jboss.migration.cli.CommandLineConstants;
import org.jboss.migration.cli.CommandLineOptions;
import org.jboss.migration.cli.logger.CommandLineMigrationLogger;
import org.jboss.migration.core.MigrationData;
import org.jboss.migration.core.ServerMigration;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.SystemEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.report.HtmlReportWriter;
import org.jboss.migration.core.report.XmlReportWriter;
import org.jboss.migration.core.task.ServerMigrationTaskResult;

public class CommandLineServerMigration {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final CommandLineParser cmdLineParser = new DefaultParser();
    private static final CommandLineOptions cmdOptions = new CommandLineOptions();

    private CommandLineServerMigration() {
    }

    public static void main(String[] args) {
        try {
            String baseDir;
            boolean interactive;
            CommandLine cmdLine = cmdLineParser.parse(cmdOptions.getOptions(), args);
            if (cmdLine.hasOption(CommandLineConstants.HELP.getArgument())) {
                CommandLineServerMigration.help();
            }
            if (!cmdLine.hasOption(CommandLineConstants.SOURCE.getArgument())) {
                throw new MissingOptionException("Missing required option: " + CommandLineConstants.SOURCE.getArgument());
            }
            if (!cmdLine.hasOption(CommandLineConstants.TARGET.getArgument())) {
                throw new MissingOptionException("Missing required option: " + CommandLineConstants.TARGET.getArgument());
            }
            Path source = CommandLineServerMigration.resolvePath(cmdLine.getOptionValue(CommandLineConstants.SOURCE.getArgument()));
            Path target = CommandLineServerMigration.resolvePath(cmdLine.getOptionValue(CommandLineConstants.TARGET.getArgument()));
            Path environment = cmdLine.hasOption(CommandLineConstants.ENVIRONMENT.getArgument()) ? CommandLineServerMigration.resolvePath(cmdLine.getOptionValue(CommandLineConstants.ENVIRONMENT.getArgument())) : null;
            boolean bl = interactive = !cmdLine.hasOption(CommandLineConstants.INTERACTIVE.getArgument()) || Boolean.parseBoolean(cmdLine.getOptionValue(CommandLineConstants.INTERACTIVE.getArgument()));
            if (!cmdLine.getArgList().isEmpty()) {
                System.out.printf("Argument(s), %s, will be discarded.\n", cmdLine.getArgList());
            }
            if ((baseDir = SystemEnvironment.INSTANCE.getPropertyAsString("baseDir")) == null) {
                throw new RuntimeException("system environment does not specifies the tool's base dir");
            }
            Path baseDirPath = Paths.get(baseDir, new String[0]);
            Path configDirPath = baseDirPath.resolve("configuration");
            Path reportsDirPath = baseDirPath.resolve("reports");
            MigrationEnvironment userEnvironment = new MigrationEnvironment();
            Path configDirEnvironment = configDirPath.resolve("environment.properties");
            if (Files.exists(configDirEnvironment, new LinkOption[0])) {
                userEnvironment.setProperties(CommandLineServerMigration.loadProperties(configDirEnvironment));
            }
            if (environment != null) {
                userEnvironment.setProperties(CommandLineServerMigration.loadProperties(environment));
            }
            MigrationData migrationData = new ServerMigration().from(source).to(target).interactive(interactive).userEnvironment(userEnvironment).run();
            String htmlReportFileName = userEnvironment.getPropertyAsString("report.html.fileName");
            String xmlReportFileName = userEnvironment.getPropertyAsString("report.xml.fileName");
            if (htmlReportFileName != null) {
                try {
                    String htmlReportTemplateFileName = userEnvironment.getPropertyAsString("report.html.templateFileName", "migration-report-template.html");
                    Path htmlReportTemplatePath = configDirPath.resolve(htmlReportTemplateFileName);
                    HtmlReportWriter.INSTANCE.toPath(reportsDirPath.resolve(htmlReportFileName), migrationData, HtmlReportWriter.ReportTemplate.from((Path)htmlReportTemplatePath));
                }
                catch (Throwable e) {
                    ServerMigrationLogger.ROOT_LOGGER.error((Object)"HTML Report write failed", e);
                }
            }
            if (xmlReportFileName != null) {
                try {
                    XmlReportWriter.INSTANCE.writeContent(reportsDirPath.resolve(xmlReportFileName).toFile(), migrationData);
                }
                catch (Throwable e) {
                    ServerMigrationLogger.ROOT_LOGGER.error((Object)"XML Report write failed", e);
                }
            }
            if (migrationData.getRootTask().getResult().getStatus() == ServerMigrationTaskResult.Status.FAIL) {
                System.exit(1);
            }
        }
        catch (ParseException pex) {
            System.err.println(pex.getLocalizedMessage());
            CommandLineServerMigration.help();
        }
        catch (Throwable t) {
            CommandLineServerMigration.abort(t);
        }
    }

    private static void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(1024);
        help.printHelp(CommandLineMigrationLogger.ROOT_LOGGER.argUsage("jboss-server-migration"), cmdOptions.getOptions(), true);
        CommandLineServerMigration.abort(null);
    }

    private static Properties loadProperties(Path propertiesFilePath) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(propertiesFilePath, new OpenOption[0]);){
            properties.load(inputStream);
        }
        return properties;
    }

    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace(STDERR);
            }
        }
        finally {
            System.exit(1);
        }
    }

    private static Path resolvePath(String s) throws IllegalArgumentException {
        Path absolutePath;
        Path path = Paths.get(s, new String[0]).normalize();
        Path path2 = absolutePath = path.isAbsolute() ? path : Paths.get(System.getProperty("user.dir"), new String[0]).resolve(path);
        if (!Files.exists(absolutePath, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + absolutePath + " does not exists.");
        }
        return absolutePath;
    }
}

