/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.logger;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public class ServerMigrationLogger_$logger
extends DelegatingBasicLogger
implements ServerMigrationLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServerMigrationLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String noConsoleAvailable = "WFCMTOOL000001: No java.io.Console available to interact with user.";
    private static final String yes = "yes";
    private static final String shortYes = "y";
    private static final String no = "no";
    private static final String shortNo = "n";
    private static final String other = "other";
    private static final String invalidResponse = "WFCMTOOL000002: Invalid response. (Valid responses are %s and %s)";
    private static final String invalidEmptyResponse = "WFCMTOOL000003: Invalid empty response.";
    private static final String errorHeader = "Error";
    private static final String yesNo = "yes/no?";
    private static final String otherChoice = "Other choice?";
    private static final String doesNotSupportsMigration = "WFCMTOOL000004: Server name = %s, version = %s does not support migration from server name = %s, version = %s.";
    private static final String serverBaseDirNotSet = "WFCMTOOL000005: Migration %s server base dir not set.";
    private static final String failedToRetrieveServerFromBaseDir = "WFCMTOOL000006: Failed to retrieve server %s, from base dir %s.";
    private static final String serverProductInfo = "%s server %s.";
    private static final String sourceFileDoesNotExists = "WFCMTOOL000007: Copy's source file %s does not exists.";
    private static final String targetPreviouslyCopiedFromDifferentSource = "WFCMTOOL000008: Target file %s previously copied from different source.";

    public ServerMigrationLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String noConsoleAvailable$str() {
        return noConsoleAvailable;
    }

    @Override
    public final IllegalStateException noConsoleAvailable() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noConsoleAvailable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String yes$str() {
        return yes;
    }

    @Override
    public final String yes() {
        return String.format(this.getLoggingLocale(), this.yes$str(), new Object[0]);
    }

    protected String shortYes$str() {
        return shortYes;
    }

    @Override
    public final String shortYes() {
        return String.format(this.getLoggingLocale(), this.shortYes$str(), new Object[0]);
    }

    protected String no$str() {
        return no;
    }

    @Override
    public final String no() {
        return String.format(this.getLoggingLocale(), this.no$str(), new Object[0]);
    }

    protected String shortNo$str() {
        return shortNo;
    }

    @Override
    public final String shortNo() {
        return String.format(this.getLoggingLocale(), this.shortNo$str(), new Object[0]);
    }

    protected String other$str() {
        return other;
    }

    @Override
    public final String other() {
        return String.format(this.getLoggingLocale(), this.other$str(), new Object[0]);
    }

    protected String invalidResponse$str() {
        return invalidResponse;
    }

    @Override
    public final String invalidResponse(String firstValues, String secondValues) {
        return String.format(this.getLoggingLocale(), this.invalidResponse$str(), firstValues, secondValues);
    }

    protected String invalidEmptyResponse$str() {
        return invalidEmptyResponse;
    }

    @Override
    public final String invalidEmptyResponse() {
        return String.format(this.getLoggingLocale(), this.invalidEmptyResponse$str(), new Object[0]);
    }

    protected String errorHeader$str() {
        return errorHeader;
    }

    @Override
    public final String errorHeader() {
        return String.format(this.getLoggingLocale(), this.errorHeader$str(), new Object[0]);
    }

    protected String yesNo$str() {
        return yesNo;
    }

    @Override
    public final String yesNo() {
        return String.format(this.getLoggingLocale(), this.yesNo$str(), new Object[0]);
    }

    protected String otherChoice$str() {
        return otherChoice;
    }

    @Override
    public final String otherChoice() {
        return String.format(this.getLoggingLocale(), this.otherChoice$str(), new Object[0]);
    }

    protected String doesNotSupportsMigration$str() {
        return doesNotSupportsMigration;
    }

    @Override
    public final IllegalArgumentException doesNotSupportsMigration(String targetName, String targetVersion, String sourceName, String sourceVersion) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.doesNotSupportsMigration$str(), targetName, targetVersion, sourceName, sourceVersion));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String serverBaseDirNotSet$str() {
        return serverBaseDirNotSet;
    }

    @Override
    public final IllegalStateException serverBaseDirNotSet(String serverName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serverBaseDirNotSet$str(), serverName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToRetrieveServerFromBaseDir$str() {
        return failedToRetrieveServerFromBaseDir;
    }

    @Override
    public final IllegalArgumentException failedToRetrieveServerFromBaseDir(String serverName, String baseDir) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.failedToRetrieveServerFromBaseDir$str(), serverName, baseDir));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void serverProductInfo(String name, ProductInfo productInfo) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.serverProductInfo$str(), (Object)name, (Object)productInfo);
    }

    protected String serverProductInfo$str() {
        return serverProductInfo;
    }

    protected String sourceFileDoesNotExists$str() {
        return sourceFileDoesNotExists;
    }

    @Override
    public final IllegalArgumentException sourceFileDoesNotExists(Path sourcePath) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.sourceFileDoesNotExists$str(), sourcePath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetPreviouslyCopiedFromDifferentSource$str() {
        return targetPreviouslyCopiedFromDifferentSource;
    }

    @Override
    public final IllegalStateException targetPreviouslyCopiedFromDifferentSource(Path targetPath) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.targetPreviouslyCopiedFromDifferentSource$str(), targetPath));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

