/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.util.List;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfigurationPath;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.DeploymentResource;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableResourceSelectors;
import org.jboss.migration.wfly10.config.management.ServerGroupResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;
import org.jboss.migration.wfly10.config.task.update.MigrateContent;
import org.jboss.migration.wfly10.config.task.update.MigrateResolvablePath;

public class MigratePersistentDeployments<S extends JBossServer<S>>
extends ManageableServerConfigurationCompositeTask.Builder<JBossServerConfigurationPath<S>> {
    public MigratePersistentDeployments() {
        this.name("deployments.migrate-persistent-deployments");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.runBuilder(params -> context -> {
            boolean confirmEachResource;
            context.getLogger().debugf("Retrieving the configuration's persistent deployments...", new Object[0]);
            List deploymentResources = params.getServerConfiguration().getChildResources(DeploymentResource.RESOURCE_TYPE);
            if (deploymentResources.isEmpty()) {
                context.getLogger().debugf("No deployments found.", new Object[0]);
                return ServerMigrationTaskResult.SKIPPED;
            }
            context.getLogger().infof("Deployments found: %s", deploymentResources.stream().map(resource -> resource.getResourceName()).collect(Collectors.toList()));
            if (context.isInteractive()) {
                if (deploymentResources.size() > 1) {
                    BasicResultHandlers.UserConfirmation userConfirmation = new BasicResultHandlers.UserConfirmation();
                    new UserConfirmation(context.getConsoleWrapper(), "Migrate all deployments?", "yes/no?", (UserConfirmation.ResultHandler)userConfirmation).execute();
                    confirmEachResource = userConfirmation.getResult() == BasicResultHandlers.UserConfirmation.Result.NO;
                } else {
                    confirmEachResource = true;
                }
            } else {
                confirmEachResource = false;
            }
            for (DeploymentResource deploymentResource : deploymentResources) {
                boolean migrateDeployment;
                if (confirmEachResource) {
                    BasicResultHandlers.UserConfirmation userConfirmation = new BasicResultHandlers.UserConfirmation();
                    new UserConfirmation(context.getConsoleWrapper(), "Migrate deployment '" + deploymentResource.getResourceName() + "'?", "yes/no?", (UserConfirmation.ResultHandler)userConfirmation).execute();
                    migrateDeployment = userConfirmation.getResult() == BasicResultHandlers.UserConfirmation.Result.YES;
                } else {
                    migrateDeployment = true;
                }
                if (migrateDeployment) continue;
                RemoveDeploymentSubtask subtaskBuilder = new RemoveDeploymentSubtask(deploymentResource);
                context.execute(subtaskBuilder.build(params));
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        });
    }

    public static class RemoveDeploymentSubtask<S extends JBossServer<S>>
    extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfigurationPath<S>> {
        protected RemoveDeploymentSubtask(DeploymentResource resource) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployments.remove-persistent-deployment").addAttribute("resource", resource.getResourceAbsoluteName()).build());
            TaskRunnable.Builder runnableBuilder = params -> context -> {
                if (params.getServerConfiguration() instanceof HostControllerConfiguration) {
                    for (DeploymentResource serverGroupDeploymentResource : ManageableResourceSelectors.selectResources(ServerGroupResource.class).andThen(ManageableResourceSelectors.selectResources(DeploymentResource.class, resource.getResourceName())).fromResources(params.getServerConfiguration())) {
                        serverGroupDeploymentResource.removeResource();
                        context.getLogger().infof("Removed persistent deployment from server group %s", (Object)resource.getResourceAbsoluteName());
                    }
                }
                resource.removeResource();
                context.getLogger().infof("Removed persistent deployment from configuration %s", (Object)resource.getResourceAbsoluteName());
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }

    public static class MigrateDeploymentSubtask<S extends JBossServer<S>>
    extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfigurationPath<S>> {
        protected MigrateDeploymentSubtask(DeploymentResource resource) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployments.migrate-persistent-deployment").addAttribute("resource", resource.getResourceAbsoluteName()).build());
            TaskRunnable.Builder runnableBuilder = params -> context -> {
                ModelNode deploymentConfig = resource.getResourceConfiguration();
                if (!deploymentConfig.hasDefined("content")) {
                    throw new ServerMigrationFailureException("Unexpected deployment " + resource.getResourceName() + " configuration: " + deploymentConfig.asString());
                }
                for (ModelNode content : deploymentConfig.get("content").asList()) {
                    if (content.hasDefined("hash")) {
                        new MigrateContent(content.get("hash").asBytes(), (JBossServerConfigurationPath)params.getSource(), params.getServerConfiguration()).run(context);
                        continue;
                    }
                    if (content.hasDefined("path")) {
                        new MigrateResolvablePath(new ResolvablePath(content), (JBossServerConfigurationPath)params.getSource(), params.getServerConfiguration()).run(context);
                        continue;
                    }
                    throw new ServerMigrationFailureException("Unexpected deployment " + resource.getResourceName() + " content: " + content.asString());
                }
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }
}

