/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.migration.core.AbstractServer;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.jboss.AbsolutePathResolver;
import org.jboss.migration.core.jboss.JBossServerConfigurationPath;
import org.jboss.migration.core.jboss.ModuleIdentifier;
import org.jboss.migration.core.jboss.ModuleSpecification;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.util.xml.SimpleXMLFileMatcher;
import org.jboss.migration.core.util.xml.XMLFiles;

public abstract class JBossServer<S extends JBossServer<S>>
extends AbstractServer
implements AbsolutePathResolver {
    private final Path domainBaseDir;
    private final Path domainConfigDir;
    private final Path domainDataDir;
    private final Path domainContentDir;
    private final Path standaloneServerDir;
    private final Path standaloneConfigDir;
    private final Path standaloneDataDir;
    private final Path standaloneContentDir;
    private final Map<String, Path> pathResolver;
    private final Modules modules;

    public JBossServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        super(migrationName, productInfo, baseDir, migrationEnvironment);
        Path domainBaseDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.domainDir"), "domain"), new String[0]);
        if (!domainBaseDir.isAbsolute()) {
            domainBaseDir = baseDir.resolve(domainBaseDir);
        }
        this.domainBaseDir = domainBaseDir;
        Path domainConfigDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.configDir"), "configuration"), new String[0]);
        if (!domainConfigDir.isAbsolute()) {
            domainConfigDir = domainBaseDir.resolve(domainConfigDir);
        }
        this.domainConfigDir = domainConfigDir;
        Path domainDataDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.dataDir"), "data"), new String[0]);
        if (!domainDataDir.isAbsolute()) {
            domainDataDir = domainBaseDir.resolve(domainDataDir);
        }
        this.domainDataDir = domainDataDir;
        Path domainContentDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.contentDir"), "content"), new String[0]);
        if (!domainContentDir.isAbsolute()) {
            domainContentDir = domainDataDir.resolve(domainContentDir);
        }
        this.domainContentDir = domainContentDir;
        Path standaloneServerDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.serverDir"), "standalone"), new String[0]);
        if (!standaloneServerDir.isAbsolute()) {
            standaloneServerDir = baseDir.resolve(standaloneServerDir);
        }
        this.standaloneServerDir = standaloneServerDir;
        Path standaloneConfigDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.configDir"), "configuration"), new String[0]);
        if (!standaloneConfigDir.isAbsolute()) {
            standaloneConfigDir = standaloneServerDir.resolve(standaloneConfigDir);
        }
        this.standaloneConfigDir = standaloneConfigDir;
        Path standaloneDataDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.dataDir"), "data"), new String[0]);
        if (!standaloneDataDir.isAbsolute()) {
            standaloneDataDir = standaloneServerDir.resolve(standaloneDataDir);
        }
        this.standaloneDataDir = standaloneDataDir;
        Path standaloneContentDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.contentDir"), "content"), new String[0]);
        if (!standaloneContentDir.isAbsolute()) {
            standaloneContentDir = standaloneDataDir.resolve(standaloneContentDir);
        }
        this.standaloneContentDir = standaloneContentDir;
        this.pathResolver = new HashMap<String, Path>();
        this.pathResolver.put("jboss.server.base.dir", standaloneServerDir);
        this.pathResolver.put("jboss.server.config.dir", standaloneConfigDir);
        this.pathResolver.put("jboss.server.data.dir", standaloneDataDir);
        this.pathResolver.put("jboss.server.content.dir", standaloneContentDir);
        this.pathResolver.put("jboss.server.log.dir", standaloneServerDir.resolve("log"));
        this.pathResolver.put("jboss.domain.base.dir", domainBaseDir);
        this.pathResolver.put("jboss.domain.config.dir", domainConfigDir);
        this.pathResolver.put("jboss.domain.data.dir", domainDataDir);
        this.pathResolver.put("jboss.domain.content.dir", domainContentDir);
        this.modules = new Modules(baseDir);
    }

    protected String getFullEnvironmentPropertyName(String propertyName) {
        return "server." + this.getMigrationName() + "." + propertyName;
    }

    protected Collection<JBossServerConfigurationPath<S>> getConfigs(Path configurationDir, Path dataDir, Path contentDir, final String xmlDocumentElementName, String envPropertyName) {
        ArrayList<JBossServerConfigurationPath<JBossServer>> configs = new ArrayList<JBossServerConfigurationPath<JBossServer>>();
        String fullEnvPropertyName = this.getFullEnvironmentPropertyName(envPropertyName);
        List<String> envConfigs = this.getMigrationEnvironment().getPropertyAsList(fullEnvPropertyName);
        if (envConfigs != null && !envConfigs.isEmpty()) {
            for (String envConfig : envConfigs) {
                Path config = Paths.get(envConfig, new String[0]);
                if (!config.isAbsolute()) {
                    config = configurationDir.resolve(config);
                }
                if (Files.exists(config, new LinkOption[0])) {
                    configs.add(new JBossServerConfigurationPath<JBossServer>(config, this, configurationDir, dataDir, contentDir));
                    continue;
                }
                ServerMigrationLogger.ROOT_LOGGER.warnf("Config file %s, specified by the environment property %s, does not exists.", config, fullEnvPropertyName);
            }
        } else {
            SimpleXMLFileMatcher scanMatcher = new SimpleXMLFileMatcher(){

                @Override
                protected boolean documentElementLocalNameMatches(String localName) {
                    return xmlDocumentElementName.equals(localName);
                }

                @Override
                protected boolean documentNamespaceURIMatches(String namespaceURI) {
                    return namespaceURI.startsWith("urn:jboss:domain:");
                }
            };
            for (Path path : XMLFiles.scan(configurationDir, false, scanMatcher)) {
                configs.add(new JBossServerConfigurationPath<JBossServer>(path, this, configurationDir, dataDir, contentDir));
            }
        }
        return Collections.unmodifiableList(configs);
    }

    public Collection<JBossServerConfigurationPath<S>> getStandaloneConfigs() {
        return this.getConfigs(this.getStandaloneConfigurationDir(), this.getStandaloneDataDir(), this.getStandaloneContentDir(), "server", "standalone.configFiles");
    }

    public Collection<JBossServerConfigurationPath<S>> getDomainDomainConfigs() {
        return this.getConfigs(this.getDomainConfigurationDir(), this.getDomainDataDir(), this.getDomainContentDir(), "domain", "domain.domainConfigFiles");
    }

    public Collection<JBossServerConfigurationPath<S>> getDomainHostConfigs() {
        return this.getConfigs(this.getDomainConfigurationDir(), this.getDomainDataDir(), this.getDomainContentDir(), "host", "domain.hostConfigFiles");
    }

    public Path getDomainDir() {
        return this.domainBaseDir;
    }

    public Path getDomainConfigurationDir() {
        return this.domainConfigDir;
    }

    public Path getDomainDataDir() {
        return this.domainDataDir;
    }

    public Path getDomainContentDir() {
        return this.domainContentDir;
    }

    public Path getStandaloneDir() {
        return this.standaloneServerDir;
    }

    public Path getStandaloneConfigurationDir() {
        return this.standaloneConfigDir;
    }

    public Path getStandaloneDataDir() {
        return this.standaloneDataDir;
    }

    public Path getStandaloneContentDir() {
        return this.standaloneContentDir;
    }

    @Override
    public Path resolveNamedPath(String path) {
        Path resolved = this.pathResolver.get(path);
        if (resolved == null) {
            try {
                Path propertyPath;
                String property = System.getProperty(path);
                if (property != null && Files.isDirectory(propertyPath = Paths.get(property, new String[0]), new LinkOption[0])) {
                    resolved = propertyPath;
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }
        return resolved;
    }

    public Modules getModules() {
        return this.modules;
    }

    public static class Modules {
        private final Path modulesDir;
        private final Path systemLayersBaseDir;
        private final Path overlayDir;

        public Modules(Path serverBaseDir) {
            this.modulesDir = serverBaseDir.resolve("modules");
            this.systemLayersBaseDir = this.modulesDir.resolve("system").resolve("layers").resolve("base");
            Path overlaysDir = this.systemLayersBaseDir.resolve(".overlays");
            Path overlaysFile = overlaysDir.resolve(".overlays");
            if (Files.exists(overlaysFile, new LinkOption[0])) {
                try {
                    String activeOverlayFileName = new String(Files.readAllBytes(overlaysFile)).trim();
                    if (!activeOverlayFileName.isEmpty()) {
                        this.overlayDir = overlaysDir.resolve(activeOverlayFileName);
                    }
                    this.overlayDir = null;
                }
                catch (IOException e) {
                    throw new ServerMigrationFailureException("failed to read overlays file", e);
                }
            } else {
                this.overlayDir = null;
            }
        }

        public Path getModulesDir() {
            return this.modulesDir;
        }

        public Module getModule(ModuleIdentifier moduleId) throws ServerMigrationFailureException {
            ModuleSpecification moduleSpecification;
            Path moduleDir = this.getModuleDir(moduleId);
            if (!Files.exists(moduleDir, new LinkOption[0])) {
                return null;
            }
            Path moduleSpecPath = moduleDir.resolve("module.xml");
            if (!Files.exists(moduleSpecPath, new LinkOption[0])) {
                return null;
            }
            try {
                moduleSpecification = ModuleSpecification.Parser.parse(moduleSpecPath);
            }
            catch (IOException | XMLStreamException e) {
                throw new ServerMigrationFailureException(e);
            }
            return new Module(moduleDir, moduleSpecification);
        }

        public Module getModule(String moduleId) throws ServerMigrationFailureException {
            return this.getModule(ModuleIdentifier.fromString(moduleId));
        }

        public Path getModuleDir(ModuleIdentifier moduleId) {
            Path overlayModuleDir;
            if (moduleId == null) {
                throw new IllegalArgumentException("The module identifier cannot be null.");
            }
            Path modulePath = Paths.get(moduleId.getName().replace('.', File.separatorChar) + File.separator + moduleId.getSlot(), new String[0]);
            if (this.overlayDir != null && Files.exists(overlayModuleDir = this.overlayDir.resolve(modulePath), new LinkOption[0])) {
                return overlayModuleDir;
            }
            Path systemLayersBaseModuleDir = this.systemLayersBaseDir.resolve(modulePath);
            if (Files.exists(systemLayersBaseModuleDir, new LinkOption[0])) {
                return systemLayersBaseModuleDir;
            }
            return this.modulesDir.resolve(modulePath);
        }
    }

    public static class Module {
        private final Path moduleDir;
        private final ModuleSpecification moduleSpecification;

        public Module(Path moduleDir, ModuleSpecification moduleSpecification) {
            this.moduleDir = moduleDir;
            this.moduleSpecification = moduleSpecification;
        }

        public ModuleSpecification getModuleSpecification() {
            return this.moduleSpecification;
        }

        public Path getModuleDir() {
            return this.moduleDir;
        }
    }

    public static interface EnvironmentProperties {
        public static final String PROPERTIES_PREFIX = "server.";
        public static final String PROPERTIES_DOMAIN_PREFIX = "domain.";
        public static final String PROPERTY_DOMAIN_BASE_DIR = "domain.domainDir";
        public static final String PROPERTY_DOMAIN_CONFIG_DIR = "domain.configDir";
        public static final String PROPERTY_DOMAIN_DATA_DIR = "domain.dataDir";
        public static final String PROPERTY_DOMAIN_CONTENT_DIR = "domain.contentDir";
        public static final String PROPERTY_DOMAIN_DOMAIN_CONFIG_FILES = "domain.domainConfigFiles";
        public static final String PROPERTY_DOMAIN_HOST_CONFIG_FILES = "domain.hostConfigFiles";
        public static final String PROPERTIES_STANDALONE_PREFIX = "standalone.";
        public static final String PROPERTY_STANDALONE_SERVER_DIR = "standalone.serverDir";
        public static final String PROPERTY_STANDALONE_CONFIG_DIR = "standalone.configDir";
        public static final String PROPERTY_STANDALONE_DATA_DIR = "standalone.dataDir";
        public static final String PROPERTY_STANDALONE_CONTENT_DIR = "standalone.contentDir";
        public static final String PROPERTY_STANDALONE_CONFIG_FILES = "standalone.configFiles";
    }
}

