/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.util.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.util.xml.XMLFileFilter;
import org.jboss.migration.core.util.xml.XMLFileMatcher;

public class XMLFiles {
    public static Collection<Path> scan(final Path start, final boolean recursive, final XMLFileMatcher matcher) throws ServerMigrationFailureException {
        final TreeSet result = new TreeSet();
        try {
            Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (matcher.matches(file)) {
                        result.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (recursive || dir.equals(start)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e == null) {
                        return recursive ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
                    }
                    throw e;
                }
            });
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("XML file scan failed!", e);
        }
        return Collections.unmodifiableSet(result);
    }

    public static void copy(Path source, Path target, XMLFileFilter ... filters) throws ServerMigrationFailureException {
        try (InputStream inputStream = Files.newInputStream(source, new OpenOption[0]);
             OutputStream outputStream = Files.newOutputStream(target, new OpenOption[0]);){
            XMLFiles.filter(inputStream, outputStream, filters);
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("xml file copy failed", e);
        }
    }

    public static void filter(Path xmlFile, XMLFileFilter ... filters) throws ServerMigrationFailureException {
        try {
            byte[] xmlFileBytes = Files.readAllBytes(xmlFile);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlFileBytes);
                 OutputStream outputStream = Files.newOutputStream(xmlFile, new OpenOption[0]);){
                XMLFiles.filter(inputStream, outputStream, filters);
            }
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("XML file filter failed.", e);
        }
    }

    private static void filter(InputStream inputStream, OutputStream outputStream, XMLFileFilter ... filters) throws ServerMigrationFailureException {
        XMLEventReader xmlEventReader = null;
        XMLEventWriter xmlEventWriter = null;
        try {
            xmlEventReader = XMLInputFactory.newInstance().createXMLEventReader(inputStream);
            xmlEventWriter = XMLOutputFactory.newInstance().createXMLEventWriter(outputStream);
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (xmlEvent.isStartElement()) {
                    StartElement startElement = xmlEvent.asStartElement();
                    XMLFileFilter.Result filterResult = XMLFileFilter.Result.NOT_APPLICABLE;
                    if (filters != null) {
                        XMLFileFilter filter;
                        XMLFileFilter[] xMLFileFilterArray = filters;
                        int n = xMLFileFilterArray.length;
                        for (int i = 0; i < n && (filterResult = (filter = xMLFileFilterArray[i]).filter(startElement, xmlEventReader, xmlEventWriter)) == XMLFileFilter.Result.NOT_APPLICABLE; ++i) {
                        }
                    }
                    switch (filterResult) {
                        case REMOVE: {
                            XMLFiles.skipTillEndElement(xmlEventReader);
                            break;
                        }
                        default: {
                            xmlEventWriter.add(xmlEvent);
                            break;
                        }
                    }
                    continue;
                }
                xmlEventWriter.add(xmlEvent);
            }
        }
        catch (XMLStreamException e) {
            throw new ServerMigrationFailureException("XML file filtering failed", e);
        }
        finally {
            if (xmlEventReader != null) {
                try {
                    xmlEventReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (xmlEventWriter != null) {
                try {
                    xmlEventWriter.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private static void skipTillEndElement(XMLEventReader xmlEventReader) throws XMLStreamException {
        int endElementsLeft = 1;
        do {
            XMLEvent xmlEvent;
            if ((xmlEvent = xmlEventReader.nextEvent()).isStartElement()) {
                ++endElementsLeft;
                continue;
            }
            if (!xmlEvent.isEndElement()) continue;
            --endElementsLeft;
        } while (xmlEventReader.hasNext() && endElementsLeft > 0);
    }
}

