/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PrimitiveListAttributeDefinition
extends ListAttributeDefinition {
    private final ModelType valueType;

    PrimitiveListAttributeDefinition(ListAttributeDefinition.Builder builder, ModelType valueType) {
        super(builder);
        this.valueType = valueType;
    }

    public ModelType getValueType() {
        return this.valueType;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle, prefix, resourceDescription);
        this.addValueTypeDescription(result);
        return result;
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle) {
        this.addValueTypeDescription(node);
    }

    protected void addValueTypeDescription(ModelNode node) {
        if (this.isAllowExpression()) {
            node.get("expressions-allowed").set(true);
        }
        node.get("value-type").set(this.valueType);
    }

    @Override
    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        if (this.isAllowExpression() && COMPLEX_TYPES.contains(this.valueType)) {
            throw new IllegalStateException();
        }
        return super.convertParameterElementExpressions(parameterElement);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle) {
        this.addValueTypeDescription(node);
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        this.handleCapabilityRequirements(context, resource, attributeValue, false);
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue) {
        this.handleCapabilityRequirements(context, resource, attributeValue, true);
    }

    private void handleCapabilityRequirements(OperationContext context, Resource resource, ModelNode attributeValue, boolean remove) {
        if (this.referenceRecorder != null && attributeValue.isDefined()) {
            List valueList = attributeValue.asList();
            String[] attributeValues = new String[valueList.size()];
            int position = 0;
            for (ModelNode current : valueList) {
                if (!current.isDefined() || current.getType().equals((Object)ModelType.EXPRESSION)) {
                    return;
                }
                attributeValues[position++] = current.asString();
            }
            if (remove) {
                this.referenceRecorder.removeCapabilityRequirements(context, resource, this.getName(), attributeValues);
            } else {
                this.referenceRecorder.addCapabilityRequirements(context, resource, this.getName(), attributeValues);
            }
        }
    }

    public static class Builder
    extends ListAttributeDefinition.Builder<Builder, PrimitiveListAttributeDefinition> {
        private final ModelType valueType;

        public Builder(String name, ModelType valueType) {
            super(name);
            this.valueType = valueType;
            this.setElementValidator(new ModelTypeValidator(valueType));
        }

        public Builder(PrimitiveListAttributeDefinition basis) {
            super(basis);
            this.valueType = basis.getValueType();
        }

        public static Builder of(String name, ModelType valueType) {
            return new Builder(name, valueType);
        }

        public ModelType getValueType() {
            return this.valueType;
        }

        @Override
        public PrimitiveListAttributeDefinition build() {
            return new PrimitiveListAttributeDefinition(this, this.getValueType());
        }
    }
}

