/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.logger;

import java.nio.file.Path;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.migration.core.ProductInfo;

@MessageLogger(projectCode="WFCMTOOL")
public interface ServerMigrationLogger
extends BasicLogger {
    public static final ServerMigrationLogger ROOT_LOGGER = (ServerMigrationLogger)Logger.getMessageLogger(ServerMigrationLogger.class, (String)ServerMigrationLogger.class.getPackage().getName());

    @Message(id=1, value="No java.io.Console available to interact with user.")
    public IllegalStateException noConsoleAvailable();

    @Message(id=0, value="yes")
    public String yes();

    @Message(id=0, value="y")
    public String shortYes();

    @Message(id=0, value="no")
    public String no();

    @Message(id=0, value="n")
    public String shortNo();

    @Message(id=0, value="other")
    public String other();

    @Message(id=2, value="Invalid response. (Valid responses are %s and %s)")
    public String invalidResponse(String var1, String var2);

    @Message(id=3, value="Invalid empty response.")
    public String invalidEmptyResponse();

    @Message(id=0, value="Error")
    public String errorHeader();

    @Message(id=0, value="yes/no?")
    public String yesNo();

    @Message(id=0, value="Other choice?")
    public String otherChoice();

    @Message(id=4, value="Server name = %s, version = %s does not support migration from server name = %s, version = %s.")
    public IllegalArgumentException doesNotSupportsMigration(String var1, String var2, String var3, String var4);

    @Message(id=5, value="Migration %s server base dir not set.")
    public IllegalStateException serverBaseDirNotSet(String var1);

    @Message(id=6, value="Failed to retrieve server %s, from base dir %s.")
    public IllegalArgumentException failedToRetrieveServerFromBaseDir(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=0, value="%s server %s.")
    public void serverProductInfo(String var1, ProductInfo var2);

    @Message(id=7, value="Copy's source file %s does not exists.")
    public IllegalArgumentException sourceFileDoesNotExists(Path var1);

    @Message(id=8, value="Target file %s previously copied from different source.")
    public IllegalStateException targetPreviouslyCopiedFromDifferentSource(Path var1);
}

