/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.OperationRejectionPolicy;
import org.jboss.as.controller.transform.OperationResultTransformer;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.DomainServerLifecycleHandlers;
import org.jboss.as.domain.controller.resources.HostExcludeResourceDefinition;
import org.jboss.as.domain.controller.resources.ProfileResourceDefinition;
import org.jboss.as.domain.controller.transformers.DeploymentTransformers;
import org.jboss.as.domain.controller.transformers.KernelAPIVersion;
import org.jboss.as.domain.controller.transformers.ManagementTransformers;
import org.jboss.as.domain.controller.transformers.ServerGroupTransformers;
import org.jboss.as.domain.controller.transformers.SocketBindingGroupTransformers;
import org.jboss.dmr.ModelNode;

public class DomainTransformers {
    public static void initializeDomainRegistry(TransformerRegistry registry) {
        DomainTransformers.registerRootTransformers(registry);
        DomainTransformers.registerChainedManagementTransformers(registry);
        DomainTransformers.registerChainedServerGroupTransformers(registry);
        DomainTransformers.registerProfileTransformers(registry);
        DomainTransformers.registerSocketBindingGroupTransformers(registry);
        DomainTransformers.registerDeploymentTransformers(registry);
    }

    private static void registerRootTransformers(TransformerRegistry registry) {
        EnumSet<KernelAPIVersion> allOthers = EnumSet.complementOf(EnumSet.of(KernelAPIVersion.CURRENT));
        ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createInstance(null);
        builder.discardChildResource(HostExcludeResourceDefinition.PATH_ELEMENT);
        DomainServerLifecycleHandlers.registerSuspendedStartTransformers(builder);
        DomainTransformers.registerNonChainedTransformers(allOthers, registry, builder, KernelAPIVersion.VERSION_3_0, KernelAPIVersion.VERSION_4_0);
        DomainServerLifecycleHandlers.registerServerLifeCycleOperationsTransformers(builder);
        DomainTransformers.registerNonChainedTransformers(allOthers, registry, builder, KernelAPIVersion.VERSION_1_7, KernelAPIVersion.VERSION_1_8);
        builder = TransformationDescriptionBuilder.Factory.createInstance(null);
        builder.discardChildResource(HostExcludeResourceDefinition.PATH_ELEMENT);
        for (KernelAPIVersion version : allOthers) {
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)version.modelVersion);
            TransformationDescription.Tools.register((TransformationDescription)builder.build(), (TransformersSubRegistration)domain);
        }
    }

    private static void registerNonChainedTransformers(Set<KernelAPIVersion> remainder, TransformerRegistry registry, ResourceTransformationDescriptionBuilder builder, KernelAPIVersion ... toRegister) {
        for (KernelAPIVersion version : toRegister) {
            remainder.remove((Object)version);
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)version.modelVersion);
            TransformationDescription.Tools.register((TransformationDescription)builder.build(), (TransformersSubRegistration)domain);
        }
    }

    private static void registerChainedManagementTransformers(TransformerRegistry registry) {
        ChainedTransformationDescriptionBuilder builder = ManagementTransformers.buildTransformerChain();
        DomainTransformers.registerChainedTransformer(registry, builder, KernelAPIVersion.VERSION_1_7, KernelAPIVersion.VERSION_1_8, KernelAPIVersion.VERSION_4_1);
    }

    private static void registerChainedServerGroupTransformers(TransformerRegistry registry) {
        ChainedTransformationDescriptionBuilder builder = ServerGroupTransformers.buildTransformerChain();
        DomainTransformers.registerChainedTransformer(registry, builder, KernelAPIVersion.VERSION_5_0, KernelAPIVersion.VERSION_4_1, KernelAPIVersion.VERSION_4_0, KernelAPIVersion.VERSION_3_0, KernelAPIVersion.VERSION_2_1, KernelAPIVersion.VERSION_2_0, KernelAPIVersion.VERSION_1_8, KernelAPIVersion.VERSION_1_7);
    }

    private static void registerProfileTransformers(TransformerRegistry registry) {
        KernelAPIVersion[] PRE_PROFILE_CLONE_VERSIONS;
        for (KernelAPIVersion version : PRE_PROFILE_CLONE_VERSIONS = new KernelAPIVersion[]{KernelAPIVersion.VERSION_3_0, KernelAPIVersion.VERSION_2_1, KernelAPIVersion.VERSION_2_0, KernelAPIVersion.VERSION_1_8, KernelAPIVersion.VERSION_1_7}) {
            ResourceTransformationDescriptionBuilder builder = TransformationDescriptionBuilder.Factory.createInstance((PathElement)ProfileResourceDefinition.PATH);
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{ProfileResourceDefinition.INCLUDES})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{ProfileResourceDefinition.INCLUDES})).end();
            builder.addOperationTransformationOverride("clone").setCustomOperationTransformer((OperationTransformer)ProfileCloneOperationTransformer.INSTANCE);
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)version.modelVersion);
            TransformationDescription.Tools.register((TransformationDescription)builder.build(), (TransformersSubRegistration)domain);
        }
    }

    private static void registerSocketBindingGroupTransformers(TransformerRegistry registry) {
        ChainedTransformationDescriptionBuilder builder = SocketBindingGroupTransformers.buildTransformerChain();
        DomainTransformers.registerChainedTransformer(registry, builder, KernelAPIVersion.VERSION_1_8, KernelAPIVersion.VERSION_1_7);
    }

    private static void registerChainedTransformer(TransformerRegistry registry, ChainedTransformationDescriptionBuilder builder, KernelAPIVersion ... versions) {
        for (Map.Entry entry : builder.build(KernelAPIVersion.toModelVersions(versions)).entrySet()) {
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)entry.getKey());
            TransformationDescription.Tools.register((TransformationDescription)((TransformationDescription)entry.getValue()), (TransformersSubRegistration)domain);
        }
    }

    private static void registerDeploymentTransformers(TransformerRegistry registry) {
        ChainedTransformationDescriptionBuilder builder = DeploymentTransformers.buildTransformerChain();
        DomainTransformers.registerChainedTransformer(registry, builder, KernelAPIVersion.VERSION_4_1, KernelAPIVersion.VERSION_4_0, KernelAPIVersion.VERSION_3_0, KernelAPIVersion.VERSION_2_1, KernelAPIVersion.VERSION_2_0, KernelAPIVersion.VERSION_1_8, KernelAPIVersion.VERSION_1_7);
    }

    private static class ProfileCloneOperationTransformer
    implements OperationTransformer {
        static ProfileCloneOperationTransformer INSTANCE = new ProfileCloneOperationTransformer();

        private ProfileCloneOperationTransformer() {
        }

        public OperationTransformer.TransformedOperation transformOperation(final TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
            if (context.getTarget().isIgnoreUnaffectedConfig()) {
                return OperationTransformer.DISCARD.transformOperation(context, address, operation);
            }
            return new OperationTransformer.TransformedOperation(operation, new OperationRejectionPolicy(){

                public boolean rejectOperation(ModelNode preparedResult) {
                    return true;
                }

                public String getFailureDescription() {
                    return DomainControllerLogger.ROOT_LOGGER.cloneOperationNotSupportedOnHost(context.getTarget().getHostName());
                }
            }, OperationResultTransformer.ORIGINAL_RESULT);
        }
    }
}

