/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddHttpsListener<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "add-undertow-https-listener";
    private static final String SERVER_NAME = "default-server";
    private static final String HTTPS_LISTENER = "https-listener";
    private static final String HTTPS_LISTENER_NAME = "https";

    public AddHttpsListener() {
        this.subtaskName(TASK_NAME);
    }

    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress configPathAddress = subsystemResource.getResourcePathAddress();
        PathAddress serverPathAddress = configPathAddress.append("server", SERVER_NAME);
        if (!config.hasDefined(new String[]{"server", SERVER_NAME})) {
            context.getLogger().debugf("Skipping task, server '%s' not found in Undertow's config %s", (Object)serverPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode server = config.get(new String[]{"server", SERVER_NAME});
        if (server.hasDefined(new String[]{HTTPS_LISTENER, HTTPS_LISTENER_NAME})) {
            context.getLogger().debugf("Skipping task, https listener already defined by server '%s', in Undertow's config %s", (Object)serverPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        PathAddress httpsListenerPathAddress = serverPathAddress.append(HTTPS_LISTENER, HTTPS_LISTENER_NAME);
        ModelNode op = Util.createAddOperation((PathAddress)httpsListenerPathAddress);
        op.get("socket-binding").set(HTTPS_LISTENER_NAME);
        op.get("security-realm").set("ApplicationRealm");
        subsystemResource.getServerConfiguration().executeManagementOperation(op);
        context.getLogger().debugf("Default HTTPS listener added to server '%s', in Undertow's config %s", (Object)serverPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
        return ServerMigrationTaskResult.SUCCESS;
    }
}

