/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly11.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class AggregateProvidersAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String aggregateProviders;
    private List<String> providers;

    public AggregateProvidersAddOperation(PathAddress subsystemPathAddress, String aggregateProviders) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.aggregateProviders = aggregateProviders;
        this.providers = new ArrayList<String>();
    }

    public AggregateProvidersAddOperation addProvider(String provider) {
        this.providers.add(provider);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("aggregate-providers", this.aggregateProviders);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.providers != null && !this.providers.isEmpty()) {
            ModelNode providersNode = operation.get("providers").setEmptyList();
            for (String provider : this.providers) {
                providersNode.add(provider);
            }
        }
        return operation;
    }
}

