/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.console;

import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.ReportError;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public class UserInput {
    private ConsoleWrapper theConsole;
    private final String[] messageLines;
    private final String prompt;
    private final ResultHandler resultHandler;

    public UserInput(ConsoleWrapper theConsole, String prompt, ResultHandler resultHandler) {
        this(theConsole, null, prompt, resultHandler);
    }

    public UserInput(ConsoleWrapper theConsole, String[] messageLines, String prompt, ResultHandler resultHandler) {
        this.theConsole = theConsole;
        this.messageLines = messageLines;
        this.prompt = prompt;
        this.resultHandler = resultHandler;
    }

    public void execute() {
        if (this.messageLines != null) {
            for (String message : this.messageLines) {
                this.theConsole.printf(message, new Object[0]);
                this.theConsole.printf(ConsoleWrapper.NEW_LINE, new Object[0]);
            }
        }
        this.theConsole.printf(this.prompt, new Object[0]);
        String temp = this.theConsole.readLine(" ", new Object[0]);
        if (temp == null) {
            this.theConsole.printf(ConsoleWrapper.NEW_LINE, new Object[0]);
        } else if (!temp.equals("")) {
            this.resultHandler.onInput(temp);
        } else {
            new ReportError(this.theConsole, ServerMigrationLogger.ROOT_LOGGER.invalidEmptyResponse()).execute();
            this.resultHandler.onError();
        }
    }

    public static interface ResultHandler {
        public void onInput(String var1);

        public void onError();
    }
}

