/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.messagingactivemq;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddHttpAcceptorsAndConnectors<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String DEFAULT_HTTP_ACCEPTOR_NAME = "http-acceptor";
    public static final String DEFAULT_HTTP_CONNECTOR_NAME = "http-connector";
    public static final String DEFAULT_SOCKET_BINDING_NAME = "http";
    public static final String DEFAULT_UNDERTOW_HTTP_LISTENER_NAME = "http";
    public static final String DEFAULT_UNDERTOW_SERVER_NAME = "default-server";
    public static final String TASK_NAME = "add-messaging-http-acceptors-and-connectors";
    private static final String SERVER = "server";
    private static final String HTTP_LISTENER = "http-listener";
    private static final String HTTP_ACCEPTOR = "http-acceptor";
    private static final String HTTP_ACCEPTOR_THROUGHPUT_NAME = "http-acceptor-throughput";
    private static final String HTTP_CONNECTOR = "http-connector";
    private static final String HTTP_CONNECTOR_THROUGHPUT_NAME = "http-connector-throughput";
    private static final String SOCKET_BINDING = "socket-binding";
    private static final String ENDPOINT = "endpoint";

    public AddHttpAcceptorsAndConnectors() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration configurationManagement = subsystemResource.getServerConfiguration();
        String httpAcceptorName = taskEnvironment.getPropertyAsString("httpAcceptorName", "http-acceptor");
        String httpConnectorName = taskEnvironment.getPropertyAsString("httpConnectorName", "http-connector");
        String socketBindingName = taskEnvironment.getPropertyAsString("socketBindingName", "http");
        String undertowHttpListenerName = taskEnvironment.getPropertyAsString("undertowHttpListenerName", "http");
        String undertowServerName = taskEnvironment.getPropertyAsString("undertowServerName", DEFAULT_UNDERTOW_SERVER_NAME);
        SubsystemResource undertow = subsystemResource.getParentResource().getSubsystemResource("undertow");
        if (undertow == null) {
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode undertowConfig = undertow.getResourceConfiguration();
        if (!undertowConfig.hasDefined(new String[]{SERVER, undertowServerName, HTTP_LISTENER, undertowHttpListenerName})) {
            context.getLogger().debug((Object)"Skipping configuration of Messaging ActiveMQ http acceptors and connectors, Undertow's default HTTP listener not found.");
            return ServerMigrationTaskResult.SKIPPED;
        }
        if (config.hasDefined(SERVER)) {
            boolean configUpdated = false;
            for (String serverName : config.get(SERVER).keys()) {
                ModelNode addOp;
                PathAddress pathAddress;
                if (!config.hasDefined(new String[]{SERVER, serverName, "http-acceptor", httpAcceptorName})) {
                    pathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)SERVER, (String)serverName), PathElement.pathElement((String)"http-acceptor", (String)httpAcceptorName)});
                    addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
                    addOp.get(HTTP_LISTENER).set(undertowHttpListenerName);
                    configurationManagement.executeManagementOperation(addOp);
                    configUpdated = true;
                    context.getLogger().debugf("HTTP Acceptor named %s added to Messaging ActiveMQ subsystem configuration.", (Object)httpAcceptorName);
                }
                if (config.hasDefined(new String[]{SERVER, serverName, "http-connector", httpConnectorName})) continue;
                pathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)SERVER, (String)serverName), PathElement.pathElement((String)"http-connector", (String)httpConnectorName)});
                addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
                addOp.get(SOCKET_BINDING).set(socketBindingName);
                addOp.get(ENDPOINT).set(httpAcceptorName);
                configurationManagement.executeManagementOperation(addOp);
                configUpdated = true;
                context.getLogger().debugf("HTTP Connector named %s added to Messaging ActiveMQ subsystem configuration.", (Object)httpConnectorName);
            }
            return configUpdated ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        }
        return ServerMigrationTaskResult.SKIPPED;
    }

    public static interface EnvironmentProperties {
        public static final String HTTP_ACCEPTOR_NAME = "httpAcceptorName";
        public static final String HTTP_CONNECTOR_NAME = "httpConnectorName";
        public static final String SOCKET_BINDING_NAME = "socketBindingName";
        public static final String UNDERTOW_HTTP_LISTENER_NAME = "undertowHttpListenerName";
        public static final String UNDERTOW_SERVER_NAME = "undertowServerName";
    }
}

