/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly11.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class ConstantRoleMapperAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String constantRoleMapper;
    private List<String> roles;

    public ConstantRoleMapperAddOperation(PathAddress subsystemPathAddress, String constantRoleMapper) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.constantRoleMapper = constantRoleMapper;
        this.roles = new ArrayList<String>();
    }

    public ConstantRoleMapperAddOperation addRole(String role) {
        this.roles.add(role);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("constant-role-mapper", this.constantRoleMapper);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.roles != null && !this.roles.isEmpty()) {
            ModelNode rolesNode = operation.get("roles").setEmptyList();
            for (String role : this.roles) {
                rolesNode.add(role);
            }
        }
        return operation;
    }
}

