/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.digest;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.sasl.digest.AbstractDigestFactory;
import org.wildfly.security.sasl.digest.DigestSaslClient;
import org.wildfly.security.util.ProviderUtil;

public class DigestClientFactory
extends AbstractDigestFactory
implements SaslClientFactory {
    public static final String[] DEFAULT_CIPHERS = new String[]{"3des", "rc4", "des", "rc4-56", "rc4-40"};
    private final Supplier<Provider[]> providers;

    public DigestClientFactory() {
        this.providers = ProviderUtil.INSTALLED_PROVIDERS;
    }

    public DigestClientFactory(Provider provider) {
        this.providers = () -> new Provider[]{provider};
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Assert.checkNotNullParam((String)"cbh", (Object)cbh);
        if (props == null) {
            props = Collections.emptyMap();
        }
        if (!this.matches(props, false)) {
            return null;
        }
        String selectedMech = this.select(mechanisms);
        if (selectedMech == null) {
            return null;
        }
        String utf8 = (String)props.get("com.sun.security.sasl.digest.utf8");
        Charset charset = utf8 == null || Boolean.valueOf(utf8) != false ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        String qopsString = (String)props.get("javax.security.sasl.qop");
        String[] qops = qopsString == null ? null : qopsString.split(",");
        String supportedCipherOpts = (String)props.get("wildfly.security.sasl.digest.ciphers");
        String[] ciphers = supportedCipherOpts == null ? DEFAULT_CIPHERS : supportedCipherOpts.split(",");
        DigestSaslClient client = new DigestSaslClient(selectedMech, protocol, serverName, cbh, authorizationId, false, charset, qops, ciphers, this.providers);
        client.init();
        return client;
    }
}

