/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.remoting;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddEndpointIfMissing<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String CONFIGURATION = "configuration";
    public static final String ENDPOINT = "endpoint";
    public static final String TASK_NAME = "add-remoting-endpoint";

    public AddEndpointIfMissing() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext taskContext, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration serverConfiguration = subsystemResource.getServerConfiguration();
        if (!config.hasDefined(new String[]{CONFIGURATION, ENDPOINT})) {
            PathAddress pathAddress = subsystemPathAddress.append(CONFIGURATION, ENDPOINT);
            ModelNode op = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
            serverConfiguration.executeManagementOperation(op);
            taskContext.getLogger().debugf("Endpoint added to Remoting subsystem configuration.", new Object[0]);
            return ServerMigrationTaskResult.SUCCESS;
        }
        return ServerMigrationTaskResult.SKIPPED;
    }
}

