/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import java.io.File;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.common.Assert;

public class AbsolutePathService
extends AbstractPathService {
    private final String absolutePath;

    public static ServiceController<String> addService(String name, String abstractPath, ServiceTarget serviceTarget) {
        return AbsolutePathService.addService(AbsolutePathService.pathNameOf(name), abstractPath, serviceTarget);
    }

    public static ServiceController<String> addService(ServiceName sname, String abstractPath, ServiceTarget serviceTarget) {
        AbsolutePathService service = new AbsolutePathService(abstractPath);
        ServiceBuilder builder = serviceTarget.addService(sname, (Service)service);
        return builder.install();
    }

    public static String convertPath(String abstractPath) {
        Assert.checkNotNullParam((String)"abstractPath", (Object)abstractPath);
        Assert.checkNotEmptyParam((String)"abstractPath", (String)abstractPath);
        File f = new File(abstractPath);
        return f.getAbsolutePath();
    }

    public static void addService(ServiceName name, ModelNode element, ServiceTarget serviceTarget) {
        String path = element.require("path").asString();
        AbsolutePathService.addService(name, path, serviceTarget);
    }

    public AbsolutePathService(String abstractPath) {
        this.absolutePath = AbsolutePathService.convertPath(abstractPath);
    }

    @Override
    protected String resolvePath() {
        return this.absolutePath;
    }
}

