/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jboss.migration.wfly10.config.management.ManageableResource;
import org.jboss.migration.wfly10.config.management.ManagementOperationException;

@FunctionalInterface
public interface ManageableResourceSelector<R extends ManageableResource> {
    public Set<R> fromResources(ManageableResource var1) throws ManagementOperationException;

    default public <I extends ManageableResource> Set<R> fromResources(I ... resources) throws ManagementOperationException {
        HashSet<R> result = new HashSet<R>();
        for (I resource : resources) {
            result.addAll(this.fromResources((ManageableResource)resource));
        }
        return result;
    }

    default public <I extends ManageableResource> Set<R> fromResources(Collection<I> resources) throws ManagementOperationException {
        return this.fromResources((ManageableResource[])resources.stream().toArray(ManageableResource[]::new));
    }

    default public ManageableResourceSelector<R> compose(ManageableResourceSelector<?> before) {
        Objects.requireNonNull(before);
        return resource -> this.fromResources((Collection)before.fromResources(resource));
    }

    default public <R1 extends ManageableResource> ManageableResourceSelector<R1> andThen(ManageableResourceSelector<R1> after) {
        Objects.requireNonNull(after);
        return resource -> after.fromResources((Collection)this.fromResources(resource));
    }
}

