/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddWebsockets<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "add-undertow-websockets";
    private static final String SERVLET_CONTAINER = "servlet-container";
    private static final String SERVLET_CONTAINER_NAME = "default";
    private static final String SETTING = "setting";
    private static final String SETTING_NAME = "websockets";

    public AddWebsockets() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        if (!config.hasDefined(new String[]{SERVLET_CONTAINER, SERVLET_CONTAINER_NAME, SETTING, SETTING_NAME})) {
            PathAddress pathAddress = subsystemResource.getResourcePathAddress().append(SERVLET_CONTAINER, SERVLET_CONTAINER_NAME).append(SETTING, SETTING_NAME);
            ModelNode addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
            subsystemResource.getServerConfiguration().executeManagementOperation(addOp);
            context.getLogger().debugf("Undertow's default Servlet Container configured to support Websockets.", new Object[0]);
            return ServerMigrationTaskResult.SUCCESS;
        }
        return ServerMigrationTaskResult.SKIPPED;
    }
}

