/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;

public class EAP6ToEAP7StandaloneConfigFileManagementInterfacesMigration {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        ServerMigrationLogger.ROOT_LOGGER.infof("Migrating management interfaces...", new Object[0]);
        boolean targetStarted = target.isStarted();
        if (!targetStarted) {
            target.start();
        }
        try {
            ModelNode op = Util.createEmptyOperation((String)"read-children-names", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")}));
            op.get("child-type").set("management-interface");
            ModelNode opResult = target.executeManagementOperation(op);
            ServerMigrationLogger.ROOT_LOGGER.debugf("Get management interfaces Op result %s", (Object)opResult.toString());
            for (ModelNode resultItem : opResult.get("result").asList()) {
                if (!resultItem.asString().equals("http-interface")) continue;
                PathAddress pathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management"), PathElement.pathElement((String)"management-interface", (String)"http-interface")});
                ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                writeAttrOp.get("name").set("http-upgrade-enabled");
                writeAttrOp.get("value").set(true);
                target.executeManagementOperation(writeAttrOp);
                ServerMigrationLogger.ROOT_LOGGER.infof("Activated HTTP Management Interface's support for HTTP Upgrade.", new Object[0]);
            }
        }
        finally {
            if (!targetStarted) {
                target.stop();
            }
            ServerMigrationLogger.ROOT_LOGGER.info((Object)"Management interfaces migration done.");
        }
    }
}

