/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7.tasks;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.CompositeSubtasksBuilder;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.ManagementInterfaceResource;
import org.jboss.migration.wfly10.config.management.SocketBindingResource;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationComponentTaskBuilder;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceTaskRunnableBuilder;

public class SetupHttpUpgradeManagement<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    private static final String TASK_NAME = "management.setup-http-upgrade";

    public SetupHttpUpgradeManagement() {
        this.name(TASK_NAME);
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().infof("HTTP upgrade management setup starting...", new Object[0]));
        this.subtasks((CompositeSubtasksBuilder)ManageableServerConfigurationCompositeSubtasks.of((ManageableServerConfigurationComponentTaskBuilder[])new ManageableServerConfigurationComponentTaskBuilder[]{new SetManagementInterfacesHttpUpgradeEnabled(), new UpdateManagementHttpsSocketBindingPort()}));
        this.afterRun(context -> context.getLogger().infof("HTTP upgrade management setup completed.", new Object[0]));
    }

    static class UpdateManagementHttpsSocketBindingPort<S>
    extends ManageableServerConfigurationLeafTask.Builder<S> {
        public static final String DEFAULT_PORT = "${jboss.management.https.port:9993}";
        private static final String SOCKET_BINDING_NAME = "management-https";
        private static final String SOCKET_BINDING_PORT_ATTR = "port";
        private static final String SUBTASK_NAME = "management.setup-http-upgrade.socket-binding.management-https.update-port";

        protected UpdateManagementHttpsSocketBindingPort() {
            this.name(SUBTASK_NAME);
            this.skipPolicyBuilders(new TaskSkipPolicy.Builder[]{buildParameters -> TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet(), buildParameters -> context -> !(buildParameters.getServerConfiguration() instanceof StandaloneServerConfiguration)});
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                SocketBindingResource resource = (SocketBindingResource)params.getResource();
                TaskEnvironment taskEnvironment = new TaskEnvironment((Environment)context.getMigrationEnvironment(), context.getTaskName());
                String envPropertyPort = taskEnvironment.getPropertyAsString(SOCKET_BINDING_PORT_ATTR);
                if (envPropertyPort == null || envPropertyPort.isEmpty()) {
                    envPropertyPort = DEFAULT_PORT;
                }
                PathAddress pathAddress = resource.getResourcePathAddress();
                ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                writeAttrOp.get("name").set(SOCKET_BINDING_PORT_ATTR);
                writeAttrOp.get("value").set(envPropertyPort);
                resource.getServerConfiguration().executeManagementOperation(writeAttrOp);
                context.getLogger().infof("Socket binding '%s' port set to " + envPropertyPort + ".", (Object)SOCKET_BINDING_NAME);
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(SocketBindingResource.class, SOCKET_BINDING_NAME, runnableBuilder);
        }
    }

    public static class SetManagementInterfacesHttpUpgradeEnabled<S>
    extends ManageableServerConfigurationLeafTask.Builder<S> {
        private static final String MANAGEMENT_INTERFACE_NAME = "http-interface";
        private static final String SUBTASK_NAME = "management.setup-http-upgrade.management-interface.http-interface.enable-http-upgrade";

        protected SetManagementInterfacesHttpUpgradeEnabled() {
            this.name(SUBTASK_NAME);
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
            ManageableResourceTaskRunnableBuilder runnableBuilder = params -> context -> {
                ManagementInterfaceResource resource = (ManagementInterfaceResource)params.getResource();
                ModelNode resourceConfig = resource.getResourceConfiguration();
                if (resourceConfig.hasDefined("http-upgrade-enabled") && resourceConfig.get("http-upgrade-enabled").asBoolean()) {
                    context.getLogger().debugf("Management interface %s http upgrade already enabled.", (Object)MANAGEMENT_INTERFACE_NAME);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress pathAddress = resource.getResourcePathAddress();
                ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                writeAttrOp.get("name").set("http-upgrade-enabled");
                writeAttrOp.get("value").set(true);
                resource.getServerConfiguration().executeManagementOperation(writeAttrOp);
                context.getLogger().infof("Management interface '%s' http upgrade enabled.", (Object)MANAGEMENT_INTERFACE_NAME);
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(ManagementInterfaceResource.class, MANAGEMENT_INTERFACE_NAME, runnableBuilder);
        }
    }
}

