/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddHttpInvoker<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "add-http-invoker";
    private static final String SERVER_NAME = "default-server";
    private static final String HOST_NAME = "default-host";
    private static final String SETTING = "setting";
    private static final String HTTP_INVOKER = "http-invoker";
    private static final String SECURITY_REALM_NAME = "ApplicationRealm";

    public AddHttpInvoker() {
        this.subtaskName(TASK_NAME);
    }

    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        if (!config.hasDefined(new String[]{"server", SERVER_NAME, "host", HOST_NAME})) {
            context.getLogger().infof("Undertow's host %s not defined, skipping task to configure the host's http-invoker.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        if (!config.hasDefined(new String[]{"server", SERVER_NAME, "host", HOST_NAME, SETTING, HTTP_INVOKER})) {
            PathAddress pathAddress = subsystemResource.getResourcePathAddress().append("server", SERVER_NAME).append("host", HOST_NAME).append(SETTING, HTTP_INVOKER);
            ModelNode addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
            addOp.get("security-realm").set(SECURITY_REALM_NAME);
            subsystemResource.getServerConfiguration().executeManagementOperation(addOp);
            context.getLogger().infof("Undertow's default host http-invoker configured.", new Object[0]);
            return ServerMigrationTaskResult.SUCCESS;
        }
        context.getLogger().infof("Undertow's host %s http-invoker is defined, skipping task to configure it.", new Object[0]);
        return ServerMigrationTaskResult.SKIPPED;
    }
}

