/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.eap.task.subsystem.elytron.Permission;

public class ConstantPermissionMapperAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String contanstPermissionMapper;
    private List<Permission> permissions;

    public ConstantPermissionMapperAddOperation(PathAddress subsystemPathAddress, String contanstPermissionMapper) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.contanstPermissionMapper = contanstPermissionMapper;
        this.permissions = new ArrayList<Permission>();
    }

    public ConstantPermissionMapperAddOperation addPermission(Permission permission) {
        this.permissions.add(permission);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("constant-permission-mapper", this.contanstPermissionMapper);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.permissions != null && !this.permissions.isEmpty()) {
            ModelNode permissionsNode = operation.get("permissions").setEmptyList();
            for (Permission permission : this.permissions) {
                permissionsNode.add(permission.toModelNode());
            }
        }
        return operation;
    }
}

