/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.config.FileFilter;
import org.wildfly.galleon.plugin.config.WildFlyPackageTasksParser;

public class WildFlyPackageTasks {
    private final List<String> mkDirs;
    private final List<FileFilter> windowsLineEndFilters;
    private final List<FileFilter> unixLineEndFilters;
    private final List<WildFlyPackageTask> tasks;

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WildFlyPackageTasks load(Path configFile) throws ProvisioningException {
        try (InputStream configStream = Files.newInputStream(configFile, new OpenOption[0]);){
            WildFlyPackageTasks wildFlyPackageTasks = new WildFlyPackageTasksParser().parse(configStream);
            return wildFlyPackageTasks;
        }
        catch (XMLStreamException e) {
            throw new ProvisioningException(Errors.parseXml((Path)configFile), (Throwable)e);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.openFile((Path)configFile), (Throwable)e);
        }
    }

    private WildFlyPackageTasks(Builder builder) {
        this.mkDirs = CollectionUtils.unmodifiable((List)builder.mkDirs);
        this.windowsLineEndFilters = CollectionUtils.unmodifiable((List)builder.windowsLineEndFilters);
        this.unixLineEndFilters = CollectionUtils.unmodifiable((List)builder.unixLineEndFilters);
        this.tasks = CollectionUtils.unmodifiable((List)builder.tasks);
    }

    public boolean hasMkDirs() {
        return !this.mkDirs.isEmpty();
    }

    public List<String> getMkDirs() {
        return this.mkDirs;
    }

    public List<FileFilter> getWindowsLineEndFilters() {
        return this.windowsLineEndFilters;
    }

    public List<FileFilter> getUnixLineEndFilters() {
        return this.unixLineEndFilters;
    }

    public boolean hasTasks() {
        return !this.tasks.isEmpty();
    }

    public List<WildFlyPackageTask> getTasks() {
        return this.tasks;
    }

    public static class Builder {
        private List<String> mkDirs = Collections.emptyList();
        private List<FileFilter> windowsLineEndFilters = Collections.emptyList();
        private List<FileFilter> unixLineEndFilters = Collections.emptyList();
        private List<WildFlyPackageTask> tasks = Collections.emptyList();

        private Builder() {
        }

        public Builder addTask(WildFlyPackageTask task) {
            this.tasks = CollectionUtils.add(this.tasks, (Object)task);
            return this;
        }

        public Builder addMkDir(String mkdirs) {
            this.mkDirs = CollectionUtils.add(this.mkDirs, (Object)mkdirs);
            return this;
        }

        public Builder addWindowsLineEndFilter(FileFilter filter) {
            this.windowsLineEndFilters = CollectionUtils.add(this.windowsLineEndFilters, (Object)filter);
            return this;
        }

        public Builder addUnixLineEndFilter(FileFilter filter) {
            this.unixLineEndFilters = CollectionUtils.add(this.unixLineEndFilters, (Object)filter);
            return this;
        }

        public WildFlyPackageTasks build() {
            return new WildFlyPackageTasks(this);
        }
    }
}

