/*
 * Copyright 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.migration.core;

import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.env.MigrationEnvironment;

/**
 * The server migration execution's context.
 * @author emmartins
 */
public class ServerMigrationContext {

    private final ConsoleWrapper consoleWrapper;
    private final boolean interactive;
    private final MigrationFiles migrationFiles;
    private final MigrationEnvironment migrationEnvironment;

    ServerMigrationContext(ConsoleWrapper consoleWrapper, boolean interactive, MigrationEnvironment migrationEnvironment) {
        this.consoleWrapper = consoleWrapper;
        this.interactive = interactive;
        this.migrationEnvironment = migrationEnvironment;
        this.migrationFiles = new MigrationFiles();
    }

    /**
     * Retrieves the migration's console.
     * @return the migration's console
     */
    public ConsoleWrapper getConsoleWrapper() {
        return consoleWrapper;
    }

    /**
     * Retreives the migration files
     * @return the migration files
     */
    public MigrationFiles getMigrationFiles() {
        return migrationFiles;
    }

    /**
     * Indicates if the migration is interactive.
     * @return true if the migration is interactive, false otherwise
     */
    public boolean isInteractive() {
        return interactive;
    }

    /**
     * Retrieves the migration's environment, used to customize the migration process.
     * @return the migrations's environment
     */
    public MigrationEnvironment getMigrationEnvironment() {
        return migrationEnvironment;
    }
}
