/*
 * Copyright 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.migration.eap;

import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.wfly10.WildFly10ServerMigration;
import org.jboss.migration.wfly10.dist.full.WildFly10FullServer;

import java.nio.file.Path;

/**
 * The EAP 7 {@link org.jboss.migration.core.Server}
 * @author emmartins
 */
public class EAP7Server extends WildFly10FullServer {
    public EAP7Server(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        super(migrationName, productInfo, baseDir, migrationEnvironment);
    }

    @Override
    protected WildFly10ServerMigration getMigration(Server source) {
        WildFly10ServerMigration serverMigration = EAP7ServerMigrations.getMigrationFrom(source);
        if (serverMigration == null) {
            serverMigration = super.getMigration(source);
        }
        return serverMigration;
    }
}
