/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.util.regex.Pattern;

public class DeploymentOverlayLinkMatcher {
    public static boolean matches(String deploymentName, String[] overlayDeployments) {
        for (String overlayDeployment : overlayDeployments) {
            if (!(DeploymentOverlayLinkMatcher.isWildcard(overlayDeployment) ? DeploymentOverlayLinkMatcher.getPattern(overlayDeployment).matcher(deploymentName).matches() : overlayDeployment.equals(deploymentName))) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildcard(String name) {
        return name.contains("*") || name.contains("?");
    }

    private static Pattern getPattern(String name) {
        return Pattern.compile(DeploymentOverlayLinkMatcher.wildcardToJavaRegexp(name));
    }

    private static String wildcardToJavaRegexp(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr is null");
        }
        String regex = expr.replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
        regex = regex.replaceAll("\\*", ".*");
        regex = regex.replaceAll("\\?", ".");
        return regex;
    }
}

