/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.AbstractServer;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.jboss.AbsolutePathResolver;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.jboss.ModuleIdentifier;
import org.jboss.migration.core.jboss.ModuleSpecification;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.util.xml.SimpleXMLFileMatcher;
import org.jboss.migration.core.util.xml.XMLFiles;

public abstract class JBossServer<S extends JBossServer<S>>
extends AbstractServer
implements AbsolutePathResolver {
    private final Path domainBaseDir;
    private final Path domainConfigDir;
    private final Path domainDataDir;
    private final Path domainContentDir;
    private final Path standaloneServerDir;
    private final Path standaloneConfigDir;
    private final Path standaloneDataDir;
    private final Path standaloneContentDir;
    private final ValueExpressionResolver expressionResolver;
    private final Map<String, Path> pathResolver;
    private final Modules modules;

    public JBossServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        super(migrationName, productInfo, baseDir, migrationEnvironment);
        Path domainBaseDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.domainDir"), "domain"), new String[0]);
        if (!domainBaseDir.isAbsolute()) {
            domainBaseDir = baseDir.resolve(domainBaseDir);
        }
        this.domainBaseDir = domainBaseDir;
        Path domainConfigDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.configDir"), "configuration"), new String[0]);
        if (!domainConfigDir.isAbsolute()) {
            domainConfigDir = domainBaseDir.resolve(domainConfigDir);
        }
        this.domainConfigDir = domainConfigDir;
        Path domainDataDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.dataDir"), "data"), new String[0]);
        if (!domainDataDir.isAbsolute()) {
            domainDataDir = domainBaseDir.resolve(domainDataDir);
        }
        this.domainDataDir = domainDataDir;
        Path domainContentDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("domain.contentDir"), "content"), new String[0]);
        if (!domainContentDir.isAbsolute()) {
            domainContentDir = domainDataDir.resolve(domainContentDir);
        }
        this.domainContentDir = domainContentDir;
        Path standaloneServerDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.serverDir"), "standalone"), new String[0]);
        if (!standaloneServerDir.isAbsolute()) {
            standaloneServerDir = baseDir.resolve(standaloneServerDir);
        }
        this.standaloneServerDir = standaloneServerDir;
        Path standaloneConfigDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.configDir"), "configuration"), new String[0]);
        if (!standaloneConfigDir.isAbsolute()) {
            standaloneConfigDir = standaloneServerDir.resolve(standaloneConfigDir);
        }
        this.standaloneConfigDir = standaloneConfigDir;
        Path standaloneDataDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.dataDir"), "data"), new String[0]);
        if (!standaloneDataDir.isAbsolute()) {
            standaloneDataDir = standaloneServerDir.resolve(standaloneDataDir);
        }
        this.standaloneDataDir = standaloneDataDir;
        Path standaloneContentDir = Paths.get(migrationEnvironment.getPropertyAsString(this.getFullEnvironmentPropertyName("standalone.contentDir"), "content"), new String[0]);
        if (!standaloneContentDir.isAbsolute()) {
            standaloneContentDir = standaloneDataDir.resolve(standaloneContentDir);
        }
        this.standaloneContentDir = standaloneContentDir;
        this.expressionResolver = new ValueExpressionResolver();
        this.pathResolver = new HashMap<String, Path>();
        this.pathResolver.put("jboss.home.dir", baseDir);
        this.pathResolver.put("jboss.server.base.dir", standaloneServerDir);
        this.pathResolver.put("jboss.server.config.dir", standaloneConfigDir);
        this.pathResolver.put("jboss.server.content.dir", standaloneContentDir);
        this.pathResolver.put("jboss.server.data.dir", standaloneDataDir);
        this.pathResolver.put("jboss.server.deploy.dir", standaloneContentDir);
        this.pathResolver.put("jboss.server.log.dir", standaloneServerDir.resolve("log"));
        this.pathResolver.put("jboss.server.temp.dir", standaloneServerDir.resolve("tmp"));
        this.pathResolver.put("jboss.domain.base.dir", domainBaseDir);
        this.pathResolver.put("jboss.domain.config.dir", domainConfigDir);
        this.pathResolver.put("jboss.domain.content.dir", domainContentDir);
        this.pathResolver.put("jboss.domain.data.dir", domainDataDir);
        this.pathResolver.put("jboss.domain.deployment.dir", domainContentDir);
        this.pathResolver.put("jboss.domain.log.dir", domainBaseDir.resolve("log"));
        this.pathResolver.put("jboss.domain.servers.dir", domainBaseDir.resolve("servers"));
        this.pathResolver.put("jboss.domain.temp.dir", domainBaseDir.resolve("tmp"));
        this.modules = new Modules(baseDir);
    }

    protected String getFullEnvironmentPropertyName(String propertyName) {
        return "server." + this.getMigrationName() + "." + propertyName;
    }

    protected Collection<JBossServerConfiguration<S>> getConfigs(JBossServerConfiguration.Type configurationType, final String xmlDocumentElementName, String envPropertyName) {
        ArrayList<JBossServerConfiguration<JBossServer>> configs = new ArrayList<JBossServerConfiguration<JBossServer>>();
        String fullEnvPropertyName = this.getFullEnvironmentPropertyName(envPropertyName);
        List<String> envConfigs = this.getMigrationEnvironment().getPropertyAsList(fullEnvPropertyName);
        if (envConfigs != null && !envConfigs.isEmpty()) {
            for (String envConfig : envConfigs) {
                Path config = Paths.get(envConfig, new String[0]);
                if (!config.isAbsolute()) {
                    config = this.getConfigurationDir(configurationType).resolve(config);
                }
                if (Files.exists(config, new LinkOption[0])) {
                    configs.add(new JBossServerConfiguration<JBossServer>(config, configurationType, this));
                    continue;
                }
                ServerMigrationLogger.ROOT_LOGGER.warnf("Config file %s, specified by the environment property %s, does not exists.", config, fullEnvPropertyName);
            }
        } else {
            SimpleXMLFileMatcher scanMatcher = new SimpleXMLFileMatcher(){

                @Override
                protected boolean documentElementLocalNameMatches(String localName) {
                    return xmlDocumentElementName.equals(localName);
                }

                @Override
                protected boolean documentNamespaceURIMatches(String namespaceURI) {
                    return namespaceURI.startsWith("urn:jboss:domain:");
                }
            };
            for (Path path : XMLFiles.scan(this.getConfigurationDir(configurationType), false, scanMatcher)) {
                configs.add(new JBossServerConfiguration<JBossServer>(path, configurationType, this));
            }
        }
        return Collections.unmodifiableList(configs);
    }

    public Collection<JBossServerConfiguration<S>> getStandaloneConfigs() {
        return this.getConfigs(JBossServerConfiguration.Type.STANDALONE, "server", "standalone.configFiles");
    }

    public Collection<JBossServerConfiguration<S>> getDomainDomainConfigs() {
        return this.getConfigs(JBossServerConfiguration.Type.DOMAIN, "domain", "domain.domainConfigFiles");
    }

    public Collection<JBossServerConfiguration<S>> getDomainHostConfigs() {
        return this.getConfigs(JBossServerConfiguration.Type.HOST, "host", "domain.hostConfigFiles");
    }

    public Path getDomainDir() {
        return this.domainBaseDir;
    }

    public Path getDomainConfigurationDir() {
        return this.domainConfigDir;
    }

    public Path getDomainDataDir() {
        return this.domainDataDir;
    }

    public Path getDomainContentDir() {
        return this.domainContentDir;
    }

    public Path getStandaloneDir() {
        return this.standaloneServerDir;
    }

    public Path getStandaloneConfigurationDir() {
        return this.standaloneConfigDir;
    }

    public Path getStandaloneDataDir() {
        return this.standaloneDataDir;
    }

    public Path getStandaloneContentDir() {
        return this.standaloneContentDir;
    }

    public Path getConfigurationDir(JBossServerConfiguration.Type configurationType) {
        return configurationType == JBossServerConfiguration.Type.STANDALONE ? this.getStandaloneConfigurationDir() : this.getDomainConfigurationDir();
    }

    public Path getDataDir(JBossServerConfiguration.Type configurationType) {
        return configurationType == JBossServerConfiguration.Type.STANDALONE ? this.getStandaloneDataDir() : this.getDomainDataDir();
    }

    public Path getContentDir(JBossServerConfiguration.Type configurationType) {
        return configurationType == JBossServerConfiguration.Type.STANDALONE ? this.getStandaloneContentDir() : this.getDomainContentDir();
    }

    public String resolveExpression(String expression) {
        return this.expressionResolver.resolve(expression);
    }

    @Override
    public Path resolveNamedPath(String name) {
        String s;
        Path path = this.pathResolver.get(name);
        if (path == null && (s = this.expressionResolver.resolvePart(name)) != null) {
            path = Paths.get(s, new String[0]);
        }
        return path;
    }

    @Override
    public Path resolvePath(String path, String relativeTo) {
        Path resolvedPath;
        if ((path = this.resolveExpression(path)) == null && relativeTo == null) {
            return null;
        }
        if (relativeTo == null) {
            resolvedPath = Paths.get(path, new String[0]).toAbsolutePath();
        } else {
            Path resolvedRelativeTo = this.resolveNamedPath(relativeTo);
            if (resolvedRelativeTo == null) {
                return null;
            }
            resolvedPath = path != null ? resolvedRelativeTo.resolve(path).toAbsolutePath() : resolvedRelativeTo.toAbsolutePath();
        }
        return resolvedPath;
    }

    public Modules getModules() {
        return this.modules;
    }

    public static class Modules {
        private final Path modulesDir;
        private final Path systemLayersBaseDir;
        private final Path overlayDir;

        public Modules(Path serverBaseDir) {
            this.modulesDir = serverBaseDir.resolve("modules");
            this.systemLayersBaseDir = this.modulesDir.resolve("system").resolve("layers").resolve("base");
            Path overlaysDir = this.systemLayersBaseDir.resolve(".overlays");
            Path overlaysFile = overlaysDir.resolve(".overlays");
            if (Files.exists(overlaysFile, new LinkOption[0])) {
                try {
                    String activeOverlayFileName = new String(Files.readAllBytes(overlaysFile)).trim();
                    if (!activeOverlayFileName.isEmpty()) {
                        this.overlayDir = overlaysDir.resolve(activeOverlayFileName);
                    }
                    this.overlayDir = null;
                }
                catch (IOException e) {
                    throw new ServerMigrationFailureException("failed to read overlays file", e);
                }
            } else {
                this.overlayDir = null;
            }
        }

        public Path getModulesDir() {
            return this.modulesDir;
        }

        public Module getModule(ModuleIdentifier moduleId) throws ServerMigrationFailureException {
            ModuleSpecification moduleSpecification;
            Path moduleDir = this.getModuleDir(moduleId);
            if (!Files.exists(moduleDir, new LinkOption[0])) {
                return null;
            }
            Path moduleSpecPath = moduleDir.resolve("module.xml");
            if (!Files.exists(moduleSpecPath, new LinkOption[0])) {
                return null;
            }
            try {
                moduleSpecification = ModuleSpecification.Parser.parse(moduleSpecPath);
            }
            catch (IOException | XMLStreamException e) {
                throw new ServerMigrationFailureException(e);
            }
            return new Module(moduleDir, moduleSpecification);
        }

        public Module getModule(String moduleId) throws ServerMigrationFailureException {
            return this.getModule(ModuleIdentifier.fromString(moduleId));
        }

        public Path getModuleDir(ModuleIdentifier moduleId) {
            Path overlayModuleDir;
            if (moduleId == null) {
                throw new IllegalArgumentException("The module identifier cannot be null.");
            }
            Path modulePath = Paths.get(moduleId.getName().replace('.', File.separatorChar) + File.separator + moduleId.getSlot(), new String[0]);
            if (this.overlayDir != null && Files.exists(overlayModuleDir = this.overlayDir.resolve(modulePath), new LinkOption[0])) {
                return overlayModuleDir;
            }
            Path systemLayersBaseModuleDir = this.systemLayersBaseDir.resolve(modulePath);
            if (Files.exists(systemLayersBaseModuleDir, new LinkOption[0])) {
                return systemLayersBaseModuleDir;
            }
            return this.modulesDir.resolve(modulePath);
        }
    }

    public static class Module {
        private final Path moduleDir;
        private final ModuleSpecification moduleSpecification;

        public Module(Path moduleDir, ModuleSpecification moduleSpecification) {
            this.moduleDir = moduleDir;
            this.moduleSpecification = moduleSpecification;
        }

        public ModuleSpecification getModuleSpecification() {
            return this.moduleSpecification;
        }

        public Path getModuleDir() {
            return this.moduleDir;
        }
    }

    public class ValueExpressionResolver
    extends org.jboss.dmr.ValueExpressionResolver {
        protected String resolvePart(String name) {
            Path path = (Path)JBossServer.this.pathResolver.get(name);
            if (path != null) {
                return path.toAbsolutePath().toString();
            }
            return super.resolvePart(name);
        }

        public String resolve(String value) {
            return this.isExpression(value) ? this.resolve(new ValueExpression(value)) : value;
        }

        protected boolean isExpression(String value) {
            int openIdx = value.indexOf("${");
            return openIdx > -1 && value.lastIndexOf(125) > openIdx;
        }
    }

    public static interface EnvironmentProperties {
        public static final String PROPERTIES_PREFIX = "server.";
        public static final String PROPERTIES_DOMAIN_PREFIX = "domain.";
        public static final String PROPERTY_DOMAIN_BASE_DIR = "domain.domainDir";
        public static final String PROPERTY_DOMAIN_CONFIG_DIR = "domain.configDir";
        public static final String PROPERTY_DOMAIN_DATA_DIR = "domain.dataDir";
        public static final String PROPERTY_DOMAIN_CONTENT_DIR = "domain.contentDir";
        public static final String PROPERTY_DOMAIN_DOMAIN_CONFIG_FILES = "domain.domainConfigFiles";
        public static final String PROPERTY_DOMAIN_HOST_CONFIG_FILES = "domain.hostConfigFiles";
        public static final String PROPERTIES_STANDALONE_PREFIX = "standalone.";
        public static final String PROPERTY_STANDALONE_SERVER_DIR = "standalone.serverDir";
        public static final String PROPERTY_STANDALONE_CONFIG_DIR = "standalone.configDir";
        public static final String PROPERTY_STANDALONE_DATA_DIR = "standalone.dataDir";
        public static final String PROPERTY_STANDALONE_CONTENT_DIR = "standalone.contentDir";
        public static final String PROPERTY_STANDALONE_CONFIG_FILES = "standalone.configFiles";
    }
}

