/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.eap.task.subsystem.elytron.MechanismConfiguration;

public class HttpAuthenticationFactoryAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String httpAuthenticationFactory;
    private String securityDomain;
    private String httpServerMechanismFactory;
    private List<MechanismConfiguration> mechanismConfigurations;

    public HttpAuthenticationFactoryAddOperation(PathAddress subsystemPathAddress, String httpAuthenticationFactory) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.httpAuthenticationFactory = httpAuthenticationFactory;
        this.mechanismConfigurations = new ArrayList<MechanismConfiguration>();
    }

    public HttpAuthenticationFactoryAddOperation securityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
        return this;
    }

    public HttpAuthenticationFactoryAddOperation httpServerMechanismFactory(String httpServerMechanismFactory) {
        this.httpServerMechanismFactory = httpServerMechanismFactory;
        return this;
    }

    public HttpAuthenticationFactoryAddOperation addMechanismConfiguration(MechanismConfiguration mechanismConfiguration) {
        this.mechanismConfigurations.add(mechanismConfiguration);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("http-authentication-factory", this.httpAuthenticationFactory);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.securityDomain != null) {
            operation.get("security-domain").set(this.securityDomain);
        }
        if (this.httpServerMechanismFactory != null) {
            operation.get("http-server-mechanism-factory").set(this.httpServerMechanismFactory);
        }
        if (this.mechanismConfigurations != null && !this.mechanismConfigurations.isEmpty()) {
            ModelNode mechanismConfigurationsNode = operation.get("mechanism-configurations").setEmptyList();
            for (MechanismConfiguration mechanismConfiguration : this.mechanismConfigurations) {
                mechanismConfigurationsNode.add(mechanismConfiguration.toModelNode());
            }
        }
        return operation;
    }
}

