/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap.task.subsystem.elytron;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.eap.task.subsystem.elytron.PermissionMapping;

public class SimplePermissionMapperAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String simplePermissionMapper;
    private List<PermissionMapping> permissionMappings;

    public SimplePermissionMapperAddOperation(PathAddress subsystemPathAddress, String simplePermissionMapper) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.simplePermissionMapper = simplePermissionMapper;
        this.permissionMappings = new ArrayList<PermissionMapping>();
    }

    public SimplePermissionMapperAddOperation addPermissionMapping(PermissionMapping permissionMapping) {
        this.permissionMappings.add(permissionMapping);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("simple-permission-mapper", this.simplePermissionMapper);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.permissionMappings != null && !this.permissionMappings.isEmpty()) {
            ModelNode permissionMappingsNode = operation.get("permission-mappings").setEmptyList();
            for (PermissionMapping permissionMapping : this.permissionMappings) {
                permissionMappingsNode.add(permissionMapping.toModelNode());
            }
        }
        return operation;
    }
}

