/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly11.task.subsystem.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class PropertiesRealmAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String propertiesRealm;
    private Properties usersProperties;
    private Properties groupsProperties;

    public PropertiesRealmAddOperation(PathAddress subsystemPathAddress, String propertiesRealm) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.propertiesRealm = propertiesRealm;
    }

    public PropertiesRealmAddOperation usersProperties(Properties properties) {
        this.usersProperties = properties;
        return this;
    }

    public PropertiesRealmAddOperation groupsProperties(Properties properties) {
        this.groupsProperties = properties;
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("properties-realm", this.propertiesRealm);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.usersProperties != null) {
            operation.get("users-properties").set(this.usersProperties.toModelNode());
        }
        if (this.groupsProperties != null) {
            operation.get("groups-properties").set(this.groupsProperties.toModelNode());
        }
        return operation;
    }

    public static class Properties {
        private final String path;
        private String relativeTo;
        private String digestRealmName;

        public Properties(String path) {
            this.path = path;
        }

        public Properties digestRealmName(String digestRealmName) {
            this.digestRealmName = digestRealmName;
            return this;
        }

        public Properties relativeTo(String relativeTo) {
            this.relativeTo = relativeTo;
            return this;
        }

        ModelNode toModelNode() {
            ModelNode modelNode = new ModelNode();
            modelNode.get("path").set(this.path);
            if (this.relativeTo != null) {
                modelNode.get("relative-to").set(this.relativeTo);
            }
            if (this.digestRealmName != null) {
                modelNode.get("digest-realm-name").set(this.digestRealmName);
            }
            return modelNode;
        }
    }
}

