/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap6.to.eap7.tasks;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.CompositeSubtasksBuilder;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.SocketBindingResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;

public class AddSocketBindingPortExpressions<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    public static final String[] SOCKET_BINDINGS = new String[]{"ajp", "http", "https"};

    public AddSocketBindingPortExpressions() {
        this.name("socket-bindings.add-port-expressions");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debugf("Adding socket binding's port expressions...", new Object[0]));
        ManageableServerConfigurationCompositeSubtasks.Builder subtasks = new ManageableServerConfigurationCompositeSubtasks.Builder();
        for (String socketBinding : SOCKET_BINDINGS) {
            subtasks.subtask(SocketBindingResource.class, socketBinding, new AddSocketBindingPortExpression(socketBinding));
        }
        this.subtasks((CompositeSubtasksBuilder)subtasks);
        this.afterRun(context -> {
            if (context.hasSucessfulSubtasks()) {
                context.getLogger().infof("Socket binding's port expressions added.", new Object[0]);
            } else {
                context.getLogger().debugf("No socket binding's port expressions added.", new Object[0]);
            }
        });
    }

    public static class AddSocketBindingPortExpression<S>
    extends ManageableResourceLeafTask.Builder<S, SocketBindingResource> {
        protected AddSocketBindingPortExpression(String resourceName) {
            this(resourceName, "jboss." + resourceName + ".port");
        }

        protected AddSocketBindingPortExpression(String resourceName, String propertyName) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("socket-binding." + resourceName + ".add-port-expression").addAttribute("resource", ((SocketBindingResource)parameters.getResource()).getResourceAbsoluteName()).build());
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
            this.runBuilder(params -> context -> {
                SocketBindingResource socketBindingResource = (SocketBindingResource)params.getResource();
                ModelNode resourceConfig = socketBindingResource.getResourceConfiguration();
                if (!resourceConfig.hasDefined("port")) {
                    context.getLogger().debugf("Socket binding %s has no port defined, task to add port property skipped.", (Object)socketBindingResource.getResourceAbsoluteName());
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ModelNode resourceAttr = resourceConfig.get("port");
                if (resourceAttr.getType() == ModelType.EXPRESSION) {
                    context.getLogger().debugf("Socket binding %s unexpected port value %s, task to add port property skipped.", (Object)socketBindingResource.getResourceAbsoluteName(), (Object)resourceAttr.asExpression().getExpressionString());
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ValueExpression valueExpression = new ValueExpression("${" + propertyName + ":" + resourceAttr.asString() + "}");
                PathAddress pathAddress = socketBindingResource.getResourcePathAddress();
                ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                writeAttrOp.get("name").set("port");
                writeAttrOp.get("value").set(valueExpression);
                socketBindingResource.getServerConfiguration().executeManagementOperation(writeAttrOp);
                context.getLogger().debugf("Socket binding %s port value expression set as %s.", (Object)pathAddress.toCLIStyleString(), (Object)valueExpression.getExpressionString());
                return ServerMigrationTaskResult.SUCCESS;
            });
        }
    }
}

