/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public class MigrationFiles {
    private final Map<Path, Path> copiedFiles = new HashMap<Path, Path>();
    private static final CopyOption[] COPY_FILE_OPTIONS = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
    private static final CopyOption[] BACKUP_FILE_OPTIONS = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};

    MigrationFiles() {
    }

    public synchronized void copy(Path source, Path target) throws IllegalArgumentException, ServerMigrationFailureException {
        if (!Files.exists(source, new LinkOption[0])) {
            throw new IllegalArgumentException("Source path " + source + " does not exists.");
        }
        if (!source.isAbsolute()) {
            throw new IllegalArgumentException("Source path " + source + " is not an absolute path.");
        }
        if (!target.isAbsolute()) {
            throw new IllegalArgumentException("Target path " + target + " is not an absolute path.");
        }
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            if (Files.isDirectory(source, new LinkOption[0])) {
                MigrationFiles.copyDir(source, target, this.copiedFiles);
            } else {
                MigrationFiles.copyFile(source, target, this.copiedFiles);
            }
        }
        catch (IOException e) {
            throw new ServerMigrationFailureException("Failed to copy " + source + " to " + target, e);
        }
    }

    private static void copyFile(Path source, Path target, Map<Path, Path> copiedFiles) throws IOException {
        if (copiedFiles.put(target, source) == null && Files.exists(target, new LinkOption[0])) {
            ServerMigrationLogger.ROOT_LOGGER.tracef("Backing up target %s before copy", target);
            Path backup = target.resolveSibling(target.getFileName().toString() + ".beforeMigration");
            Files.move(target, backup, BACKUP_FILE_OPTIONS);
        }
        ServerMigrationLogger.ROOT_LOGGER.tracef("Copying file %s to %s", source, target);
        Files.copy(source, target, COPY_FILE_OPTIONS);
        ServerMigrationLogger.ROOT_LOGGER.tracef("File %s copied to %s.", source, target);
    }

    private static void copyDir(Path source, Path target, Map<Path, Path> copiedFiles) throws IOException {
        Files.walkFileTree(source, CopyVisitor.FILE_VISITOR_OPTIONS, Integer.MAX_VALUE, new CopyVisitor(source, target, copiedFiles));
    }

    private static class CopyVisitor
    extends SimpleFileVisitor<Path> {
        static final EnumSet<FileVisitOption> FILE_VISITOR_OPTIONS = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        static final CopyOption[] COPY_DIR_OPTIONS = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
        private final Map<Path, Path> copiedFiles;
        private final Path source;
        private final Path target;

        CopyVisitor(Path source, Path target, Map<Path, Path> copiedFiles) {
            this.source = source;
            this.target = target;
            this.copiedFiles = copiedFiles;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path sourceDir, BasicFileAttributes attrs) throws IOException {
            block2: {
                Path targetDir = this.getTargetPath(sourceDir);
                try {
                    Files.copy(sourceDir, targetDir, COPY_DIR_OPTIONS);
                }
                catch (FileAlreadyExistsException e) {
                    if (Files.isDirectory(targetDir, new LinkOption[0])) break block2;
                    throw e;
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attrs) throws IOException {
            Path targetFile = this.getTargetPath(sourceFile);
            MigrationFiles.copyFile(sourceFile, targetFile, this.copiedFiles);
            return FileVisitResult.CONTINUE;
        }

        private Path getTargetPath(Path sourcePath) {
            return this.target.resolve(this.source.relativize(sourcePath));
        }

        @Override
        public FileVisitResult postVisitDirectory(Path sourceDir, IOException e) throws IOException {
            if (e == null) {
                Path targetDir = this.getTargetPath(sourceDir);
                Files.setLastModifiedTime(targetDir, Files.getLastModifiedTime(sourceDir, new LinkOption[0]));
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

