/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskRunnable;

public class XmlConfigurationMigration<S extends JBossServer<S>>
implements TaskRunnable {
    private final Set<ComponentFactory> componentFactories;
    private final JBossServerConfiguration<S> sourceConfiguration;
    private final JBossServerConfiguration<S> targetConfiguration;

    protected XmlConfigurationMigration(JBossServerConfiguration<S> sourceConfiguration, JBossServerConfiguration<S> targetConfiguration, Set<ComponentFactory> componentFactories) {
        this.sourceConfiguration = sourceConfiguration;
        this.targetConfiguration = targetConfiguration;
        this.componentFactories = Collections.unmodifiableSet(componentFactories);
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        HashMap<String, ArrayList<Component>> componentsMap = new HashMap<String, ArrayList<Component>>();
        for (ComponentFactory componentFactory : this.componentFactories) {
            Component component = componentFactory.newComponent();
            component.beforeProcessingElements(this.sourceConfiguration, this.targetConfiguration, context);
            for (String elementLocalName : component.getElementLocalNames()) {
                ArrayList<Component> elementComponents = (ArrayList<Component>)componentsMap.get(elementLocalName);
                if (elementComponents == null) {
                    elementComponents = new ArrayList<Component>();
                    componentsMap.put(elementLocalName, elementComponents);
                }
                elementComponents.add(component);
            }
        }
        try {
            Throwable throwable = null;
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.targetConfiguration.getPath().toFile()));){
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
                reader.require(7, null, null);
                while (reader.hasNext()) {
                    List elementComponents;
                    if (reader.next() != 1 || (elementComponents = (List)componentsMap.get(reader.getLocalName())) == null) continue;
                    for (Component elementComponent : elementComponents) {
                        elementComponent.processElement(reader, this.sourceConfiguration, this.targetConfiguration, context);
                    }
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new ServerMigrationFailureException(e);
        }
        for (List list : componentsMap.values()) {
            for (Component component : list) {
                component.afterProcessingElements(this.sourceConfiguration, this.targetConfiguration, context);
            }
        }
        return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
    }

    public static class Builder<S extends JBossServer<S>> {
        private final Set<ComponentFactory> componentFactories = new HashSet<ComponentFactory>();

        public synchronized Builder<S> componentFactory(ComponentFactory componentFactory) {
            this.componentFactories.add(componentFactory);
            return this;
        }

        public XmlConfigurationMigration<S> build(JBossServerConfiguration<S> sourceConfiguration, JBossServerConfiguration<S> targetConfiguration) {
            return new XmlConfigurationMigration<S>(sourceConfiguration, targetConfiguration, this.componentFactories);
        }
    }

    public static interface ComponentFactory {
        public Component newComponent();
    }

    public static interface Component {
        public Set<String> getElementLocalNames();

        default public void beforeProcessingElements(JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration, TaskContext taskContext) {
        }

        public void processElement(XMLStreamReader var1, JBossServerConfiguration var2, JBossServerConfiguration var3, TaskContext var4) throws IOException;

        default public void afterProcessingElements(JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration, TaskContext taskContext) {
        }
    }
}

