/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task;

import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.migration.core.MigrationFiles;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.TaskExecution;
import org.jboss.migration.core.task.TaskExecutionImpl;
import org.jboss.migration.core.task.component.TaskRunnable;

public class TaskContextImpl
implements TaskContext {
    private final TaskExecutionImpl taskExecution;

    TaskContextImpl(TaskExecutionImpl taskExecution) {
        this.taskExecution = taskExecution;
    }

    @Override
    public ServerMigrationTaskName getTaskName() {
        return this.taskExecution.getTaskName();
    }

    @Override
    public TaskExecution getParentTask() {
        return this.taskExecution.getParent();
    }

    @Override
    public List<? extends TaskExecution> getSubtasks() {
        return this.taskExecution.getSubtasks();
    }

    @Override
    public boolean hasSucessfulSubtasks() {
        for (TaskExecution taskExecution : this.getSubtasks()) {
            ServerMigrationTaskResult result = taskExecution.getResult();
            if (result == null || result.getStatus() != ServerMigrationTaskResult.Status.SUCCESS) continue;
            return true;
        }
        return false;
    }

    @Override
    public TaskExecutionImpl execute(ServerMigrationTask subtask) throws IllegalStateException, ServerMigrationFailureException {
        return this.taskExecution.execute(subtask);
    }

    @Override
    public TaskExecution execute(final ServerMigrationTaskName taskName, final TaskRunnable taskRunnable) throws IllegalStateException, ServerMigrationFailureException {
        return this.execute(new ServerMigrationTask(){

            @Override
            public ServerMigrationTaskName getName() {
                return taskName;
            }

            @Override
            public ServerMigrationTaskResult run(TaskContext context) throws ServerMigrationFailureException {
                return taskRunnable.run(context);
            }
        });
    }

    protected ServerMigrationContext getServerMigrationContext() {
        return this.taskExecution.getServerMigrationContext();
    }

    @Override
    public ConsoleWrapper getConsoleWrapper() {
        return this.getServerMigrationContext().getConsoleWrapper();
    }

    @Override
    public MigrationFiles getMigrationFiles() {
        return this.getServerMigrationContext().getMigrationFiles();
    }

    @Override
    public boolean isInteractive() {
        return this.getServerMigrationContext().isInteractive();
    }

    @Override
    public MigrationEnvironment getMigrationEnvironment() {
        return this.getServerMigrationContext().getMigrationEnvironment();
    }

    @Override
    public Logger getLogger() {
        return this.taskExecution.getLogger();
    }
}

