/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.nio.file.Path;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskRunnable;

public class CopyPath
implements TaskRunnable {
    private final Path sourcePath;
    private final Path targetPath;

    public CopyPath(Path sourcePath, Path targetPath) {
        this.sourcePath = sourcePath;
        this.targetPath = targetPath;
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        context.getLogger().debugf("Source's path: %s", (Object)this.sourcePath);
        context.getLogger().debugf("Target's path: %s", (Object)this.targetPath);
        if (!this.sourcePath.equals(this.targetPath)) {
            context.getMigrationFiles().copy(this.sourcePath, this.targetPath);
            context.getLogger().infof("Resource with path %s migrated.", (Object)this.sourcePath, (Object)this.targetPath);
            return new ServerMigrationTaskResult.Builder().success().addAttribute("sourcePath", this.sourcePath).addAttribute("targetPath", this.targetPath).build();
        }
        return new ServerMigrationTaskResult.Builder().skipped().addAttribute("sourcePath", this.sourcePath).addAttribute("targetPath", this.targetPath).build();
    }
}

