/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.infinispan;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class UpdateWebCache<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "update-infinispan-web-cache";
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE_CONTAINER_NAME = "web";
    private static final String DISTRIBUTED_CACHE = "distributed-cache";
    private static final String LOCAL_CACHE = "local-cache";
    private static final String CACHE_NAME = "concurrent";
    private static final String L1_LIFESPAN = "l1-lifespan";
    private static final String MODE = "mode";
    private static final String OWNERS = "owners";
    private static final String STORE = "store";
    private static final String STORE_NAME = "file";
    private static final String PASSIVATION = "passivation";
    private static final String PURGE = "purge";

    public UpdateWebCache() {
        this.subtaskName(TASK_NAME);
    }

    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        if (!config.hasDefined(CACHE_CONTAINER)) {
            context.getLogger().debugf("No cache containers found, skipping task...", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        if (!config.hasDefined(new String[]{CACHE_CONTAINER, CACHE_CONTAINER_NAME})) {
            context.getLogger().debugf("No cache container named %s found, skipping task...", (Object)CACHE_CONTAINER_NAME);
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode cacheContainerConfig = config.get(new String[]{CACHE_CONTAINER, CACHE_CONTAINER_NAME});
        PathAddress cacheContainerPathAddress = subsystemResource.getResourcePathAddress().append(new PathElement[]{PathElement.pathElement((String)CACHE_CONTAINER, (String)CACHE_CONTAINER_NAME)});
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        if (cacheContainerConfig.hasDefined(DISTRIBUTED_CACHE)) {
            if (cacheContainerConfig.hasDefined(new String[]{DISTRIBUTED_CACHE, CACHE_NAME})) {
                context.getLogger().debugf("Cache container named %s already defines distributed cache named %s, skipping task...", (Object)CACHE_CONTAINER_NAME, (Object)CACHE_NAME);
                return ServerMigrationTaskResult.SKIPPED;
            }
            PathAddress cachePathAddress = cacheContainerPathAddress.append(new PathElement[]{PathElement.pathElement((String)DISTRIBUTED_CACHE, (String)CACHE_NAME)});
            ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
            cacheAddOperation.get(L1_LIFESPAN).set(0);
            cacheAddOperation.get(MODE).set("SYNC");
            cacheAddOperation.get(OWNERS).set(2);
            compositeOperationBuilder.addStep(cacheAddOperation);
            ModelNode cacheFileStoreAddOperation = Util.createAddOperation((PathAddress)cachePathAddress.append(STORE, STORE_NAME));
            compositeOperationBuilder.addStep(cacheFileStoreAddOperation);
        } else {
            if (cacheContainerConfig.hasDefined(new String[]{LOCAL_CACHE, CACHE_NAME})) {
                context.getLogger().debugf("Cache container named %s already defines local cache named %s, skipping task...", (Object)CACHE_CONTAINER_NAME, (Object)CACHE_NAME);
                return ServerMigrationTaskResult.SKIPPED;
            }
            PathAddress cachePathAddress = cacheContainerPathAddress.append(new PathElement[]{PathElement.pathElement((String)LOCAL_CACHE, (String)CACHE_NAME)});
            ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
            compositeOperationBuilder.addStep(cacheAddOperation);
            ModelNode cacheFileStoreAddOperation = Util.createAddOperation((PathAddress)cachePathAddress.append(STORE, STORE_NAME));
            cacheFileStoreAddOperation.get(PASSIVATION).set(true);
            cacheFileStoreAddOperation.get(PURGE).set(false);
            compositeOperationBuilder.addStep(cacheFileStoreAddOperation);
        }
        subsystemResource.getServerConfiguration().executeManagementOperation(compositeOperationBuilder.build().getOperation());
        context.getLogger().infof("Cache '%s' added to cache container '%s'.", (Object)CACHE_NAME, (Object)CACHE_CONTAINER_NAME);
        return ServerMigrationTaskResult.SUCCESS;
    }
}

