/*
 * Copyright 2017 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.migration.core.task;

import org.jboss.logging.Logger;
import org.jboss.migration.core.ServerMigrationContext;

import java.util.List;

/**
 * @author emmartins
 */
public interface TaskExecution {
    Logger getLogger();
    ServerMigrationTaskResult getResult();
    ServerMigrationContext getServerMigrationContext();
    List<TaskExecution> getSubtasks();
    long getStartTime();
    ServerMigrationTaskName getTaskName();
    long getTaskNumber();
    ServerMigrationTaskPath getTaskPath();
}
