/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.infinispan;

import java.util.Objects;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.jboss.ModuleIdentifier;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class FixHibernateCacheModuleName<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "fix-hibernate-cache-module-name";
    private final String defaultNewModuleName;
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String HIBERNATE = "hibernate";
    private static final String MODULE_ATTR_NAME = "module";

    public FixHibernateCacheModuleName(String defaultNewModuleName) {
        this.subtaskName(TASK_NAME);
        this.defaultNewModuleName = Objects.requireNonNull(defaultNewModuleName);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration configurationManagement = subsystemResource.getServerConfiguration();
        if (!config.hasDefined(new String[]{CACHE_CONTAINER, HIBERNATE})) {
            context.getLogger().debugf("Hibernate cache container not defined.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode cache = config.get(new String[]{CACHE_CONTAINER, HIBERNATE});
        if (!cache.hasDefined(MODULE_ATTR_NAME)) {
            context.getLogger().debugf("Hibernate cache container module not defined.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        String newModuleName = taskEnvironment.getPropertyAsString("moduleName", this.defaultNewModuleName);
        String moduleName = cache.get(MODULE_ATTR_NAME).asString();
        if (ModuleIdentifier.fromString((String)moduleName).equals(ModuleIdentifier.fromString((String)newModuleName))) {
            context.getLogger().debugf("Hibernate cache container module already defined with correct module name.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)CACHE_CONTAINER, (String)HIBERNATE)}));
        op.get("name").set(MODULE_ATTR_NAME);
        op.get("value").set(newModuleName);
        configurationManagement.executeManagementOperation(op);
        return ServerMigrationTaskResult.SUCCESS;
    }

    public static interface EnvironmentProperties {
        public static final String NEW_MODULE_NAME = "moduleName";
    }
}

