/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.jgroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class UpdateProtocols<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    private final List<Operation> operations;
    private static final String STACK = "stack";
    private static final String PROTOCOL = "protocol";

    public UpdateProtocols(Operations operations) {
        this.subtaskName("update-protocols");
        this.operations = Collections.unmodifiableList(operations.operations);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration serverConfiguration = subsystemResource.getServerConfiguration();
        ModelNode stacks = config.get(STACK);
        if (!stacks.isDefined()) {
            context.getLogger().debugf("No stacks defined.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        HashSet<String> protocolsRemoved = new HashSet<String>();
        HashSet<String> protocolsAdded = new HashSet<String>();
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        for (Operation operation : this.operations) {
            for (String stackName : stacks.keys()) {
                ModelNode stack = config.get(new String[]{STACK, stackName});
                if (operation.removeProtocol != null) {
                    if (!stack.hasDefined(new String[]{PROTOCOL, operation.removeProtocol})) continue;
                    compositeOperationBuilder.addStep(Util.createRemoveOperation((PathAddress)subsystemPathAddress.append(STACK, stackName).append(PROTOCOL, operation.removeProtocol)));
                    protocolsRemoved.add(operation.removeProtocol);
                }
                if (operation.addProtocol == null || stack.hasDefined(new String[]{PROTOCOL, operation.addProtocol})) continue;
                compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)subsystemPathAddress.append(STACK, stackName).append(PROTOCOL, operation.addProtocol)));
                if (protocolsRemoved.remove(operation.addProtocol)) continue;
                protocolsAdded.add(operation.addProtocol);
            }
        }
        if (protocolsRemoved.isEmpty() && protocolsAdded.isEmpty()) {
            context.getLogger().debugf("No protocols removed or added.", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        serverConfiguration.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        return new ServerMigrationTaskResult.Builder().success().addAttribute("protocols-removed", protocolsRemoved).addAttribute("protocols-added", protocolsAdded).build();
    }

    protected static class Operation {
        String addProtocol;
        String removeProtocol;

        protected Operation() {
        }
    }

    public static class Operations {
        private final List<Operation> operations = new ArrayList<Operation>();

        protected Operations operation(String removeProtocol, String addProtocol) {
            Operation operation = new Operation();
            operation.removeProtocol = removeProtocol;
            operation.addProtocol = addProtocol;
            this.operations.add(operation);
            return this;
        }

        public Operations add(String protocol) {
            return this.operation(null, protocol);
        }

        public Operations readd(String protocol) {
            return this.operation(protocol, protocol);
        }

        public Operations replace(String oldProtocol, String newProtocol) {
            return this.operation(oldProtocol, newProtocol);
        }

        public Operations remove(String protocol) {
            return this.operation(protocol, null);
        }
    }
}

