/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.ModuleIdentifier;
import org.jboss.migration.core.jboss.ModuleSpecification;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;

public class ModulesMigrationTask
implements ServerMigrationTask {
    public static final String ENVIRONMENT_PROPERTY_INCLUDES = "modules.includes";
    public static final String ENVIRONMENT_PROPERTY_EXCLUDES = "modules.excludes";
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("modules.migrate-modules-requested-by-user").build();
    private final JBossServer source;
    private final JBossServer target;
    private final String requestedBy;

    public ModulesMigrationTask(JBossServer source, JBossServer target) {
        this(source, target, "environment");
    }

    protected ModulesMigrationTask(JBossServer source, JBossServer target, String requestedBy) {
        this.source = source;
        this.target = target;
        this.requestedBy = requestedBy;
    }

    @Override
    public ServerMigrationTaskName getName() {
        return TASK_NAME;
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        TaskEnvironment taskEnvironment = new TaskEnvironment((Environment)context.getMigrationEnvironment(), this.getName());
        if (taskEnvironment.isSkippedByEnvironment()) {
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModuleMigrator moduleMigrator = new ModuleMigrator(this.source, this.target, context.getMigrationEnvironment());
        this.migrateModules(moduleMigrator, context);
        if (context.hasSucessfulSubtasks()) {
            return ServerMigrationTaskResult.SUCCESS;
        }
        context.getLogger().debugf("No modules required migration.", (Object)this.requestedBy);
        return ServerMigrationTaskResult.SKIPPED;
    }

    protected void migrateModules(ModuleMigrator moduleMigrator, TaskContext context) {
        context.getConsoleWrapper().println();
        context.getLogger().infof("--- Migrating modules requested by environment...", new Object[0]);
        context.getConsoleWrapper().println();
        List<String> includedModules = context.getMigrationEnvironment().getPropertyAsList(ENVIRONMENT_PROPERTY_INCLUDES, Collections.emptyList());
        if (includedModules.isEmpty()) {
            context.getLogger().infof("No modules to migrate.", (Object)this.requestedBy);
            return;
        }
        for (String module : includedModules) {
            moduleMigrator.migrateModule(module, "requested by environment", context);
        }
    }

    public static class ModuleMigrator {
        private final JBossServer.Modules sourceModules;
        private final JBossServer.Modules targetModules;
        private final Set<ModuleIdentifier> excludedByEnvironment;

        protected ModuleMigrator(JBossServer source, JBossServer target, MigrationEnvironment environment) {
            this.sourceModules = source.getModules();
            this.targetModules = target.getModules();
            this.excludedByEnvironment = new HashSet<ModuleIdentifier>();
            for (String excludedModule : environment.getPropertyAsList(ModulesMigrationTask.ENVIRONMENT_PROPERTY_EXCLUDES, Collections.emptyList())) {
                this.excludedByEnvironment.add(ModuleIdentifier.fromString(excludedModule));
            }
        }

        public void migrateModule(String moduleId, String reason, TaskContext context) {
            this.migrateModule(ModuleIdentifier.fromString(moduleId), reason, context);
        }

        public void migrateModule(final ModuleIdentifier moduleIdentifier, final String reason, TaskContext context) throws IllegalStateException {
            if (this.excludedByEnvironment.contains(moduleIdentifier)) {
                context.getLogger().debugf("Skipping module %s migration, it's excluded by environment.", (Object)moduleIdentifier);
                return;
            }
            final JBossServer.Module sourceModule = this.sourceModules.getModule(moduleIdentifier);
            if (sourceModule == null) {
                throw new IllegalStateException("Migration of module " + moduleIdentifier + " required, but module not found in source server.");
            }
            if (this.targetModules.getModule(moduleIdentifier) != null) {
                context.getLogger().debugf("Skipping module %s migration, already exists in target.", (Object)moduleIdentifier, (Object)reason);
                return;
            }
            final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(context.getTaskName().getName() + ".migrate-module").addAttribute("id", moduleIdentifier.toString()).build();
            ServerMigrationTask subtask = new ServerMigrationTask(){

                @Override
                public ServerMigrationTaskName getName() {
                    return taskName;
                }

                @Override
                public ServerMigrationTaskResult run(TaskContext context) {
                    context.getMigrationFiles().copy(sourceModule.getModuleDir(), targetModules.getModuleDir(moduleIdentifier));
                    context.getLogger().infof("Module %s migrated.", (Object)moduleIdentifier);
                    return new ServerMigrationTaskResult.Builder().success().addAttribute("reason", reason).build();
                }
            };
            context.execute(subtask);
            for (ModuleSpecification.Dependency dependency : sourceModule.getModuleSpecification().getDependencies()) {
                this.migrateModule(dependency.getId(), "migrated module " + moduleIdentifier + " depends on it", context);
            }
        }
    }
}

