/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.nio.file.Path;
import org.jboss.migration.core.jboss.ContentHashToPathMapper;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskRunnable;

public class MigrateContent
implements TaskRunnable {
    private final byte[] contentHash;
    private final JBossServerConfiguration sourceConfiguration;
    private final JBossServerConfiguration targetConfiguration;

    public MigrateContent(byte[] contentHash, JBossServerConfiguration sourceConfiguration, JBossServerConfiguration targetConfiguration) {
        this.contentHash = contentHash;
        this.sourceConfiguration = sourceConfiguration;
        this.targetConfiguration = targetConfiguration;
    }

    public ServerMigrationTaskResult run(TaskContext context) {
        Path contentPath = new ContentHashToPathMapper().apply(this.contentHash);
        Path contentSource = this.sourceConfiguration.getContentDir().resolve(contentPath);
        context.getLogger().infof("Source content's path: %s", (Object)contentSource);
        Path contentTarget = this.targetConfiguration.getContentDir().resolve(contentPath);
        context.getLogger().infof("Target content's path: %s", (Object)contentTarget);
        if (!contentSource.equals(contentTarget)) {
            context.getMigrationFiles().copy(contentSource, contentTarget);
            context.getLogger().infof("Source's content %s migrated to %s.", (Object)contentSource, (Object)contentTarget);
            return ServerMigrationTaskResult.SUCCESS;
        }
        context.getLogger().infof("Source equals target content path, skipping content migration", new Object[0]);
        return ServerMigrationTaskResult.SKIPPED;
    }
}

