/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.cli;

import java.util.ArrayList;
import java.util.List;
import org.jboss.migration.cli.commonscli.Option;
import org.jboss.migration.cli.commonscli.Options;

public class CommandLineOptions {
    private final Options nonDeprecatedOptions;
    private final Options deprecatedOptions;
    private final Options allOptions = new Options();

    protected CommandLineOptions(Builder builder) {
        this.nonDeprecatedOptions = new Options();
        for (Option option : builder.nonDeprecatedOptions) {
            this.nonDeprecatedOptions.addOption(option);
            this.allOptions.addOption(option);
        }
        this.deprecatedOptions = new Options();
        for (Option option : builder.deprecatedOptions) {
            this.deprecatedOptions.addOption(option);
            this.allOptions.addOption(option);
        }
    }

    public Options getAllOptions() {
        return this.allOptions;
    }

    public Options getDeprecatedOptions() {
        return this.deprecatedOptions;
    }

    public Options getNonDeprecatedOptions() {
        return this.nonDeprecatedOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static class Builder {
        private final List<Option> nonDeprecatedOptions = new ArrayList<Option>();
        private final List<Option> deprecatedOptions = new ArrayList<Option>();

        protected Builder() {
        }

        public Builder deprecatedOption(Option option) {
            this.deprecatedOptions.add(option);
            return this;
        }

        public Builder nonDeprecatedOption(Option option) {
            this.nonDeprecatedOptions.add(option);
            return this;
        }

        public CommandLineOptions build() {
            return new CommandLineOptions(this);
        }
    }
}

