/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.report;

import java.util.ArrayList;
import java.util.List;
import org.jboss.migration.core.MigrationData;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskExecution;

public class SummaryReportWriter {
    public static SummaryReportWriter INSTANCE = new SummaryReportWriter();
    private static final String TASK_NAME_LEVEL_INDENT = " ";
    private static final char SEPARATOR_CHAR = '.';
    private static final int MIN_SEPARATOR_LENGTH = 3;

    private SummaryReportWriter() {
    }

    public String toString(MigrationData migrationData) {
        List<SummaryTaskEntry> summaryTaskEntries = this.getSummaryTaskEntries(migrationData);
        int taskNameAndSeparatorLength = this.getTaskNameAndSeparatorLength(summaryTaskEntries);
        String lineSeparator = this.getLineSeparator(taskNameAndSeparatorLength);
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append(lineSeparator);
        sb.append(" Task Summary\n");
        sb.append(lineSeparator);
        sb.append('\n');
        this.appendTasks(sb, summaryTaskEntries, taskNameAndSeparatorLength);
        sb.append('\n');
        sb.append(lineSeparator);
        this.appendRootTaskResult(sb, migrationData);
        sb.append(lineSeparator);
        return sb.toString();
    }

    protected List<SummaryTaskEntry> getSummaryTaskEntries(MigrationData migrationData) {
        int maxTaskPathSizeToDisplaySubtasks = Integer.valueOf(migrationData.getServerMigrationEnvironment().getPropertyAsString("report.summary.maxTaskPathSizeToDisplaySubtasks", "5"));
        ArrayList<SummaryTaskEntry> summaryTaskEntries = new ArrayList<SummaryTaskEntry>();
        int taskDepth = 0;
        this.getSummaryTaskEntry(migrationData.getRootTask(), TASK_NAME_LEVEL_INDENT, summaryTaskEntries, taskDepth, maxTaskPathSizeToDisplaySubtasks);
        return summaryTaskEntries;
    }

    protected void getSummaryTaskEntry(TaskExecution task, String prefix, List<SummaryTaskEntry> summaryTaskEntries, int taskDepth, int maxTaskPathSizeToDisplaySubtasks) {
        if (task.getResult().getStatus() == ServerMigrationTaskResult.Status.SKIPPED) {
            return;
        }
        String taskNameWithPrefix = prefix + task.getTaskName().toString();
        summaryTaskEntries.add(new SummaryTaskEntry(taskNameWithPrefix, task.getResult()));
        String subtaskPrefix = TASK_NAME_LEVEL_INDENT + prefix;
        if (++taskDepth > maxTaskPathSizeToDisplaySubtasks) {
            return;
        }
        for (TaskExecution subtask : task.getSubtasks()) {
            this.getSummaryTaskEntry(subtask, subtaskPrefix, summaryTaskEntries, taskDepth, maxTaskPathSizeToDisplaySubtasks);
        }
    }

    protected int getTaskNameAndSeparatorLength(List<SummaryTaskEntry> summaryTaskEntries) {
        int maxTaskNameLength = 0;
        for (SummaryTaskEntry summaryTaskEntry : summaryTaskEntries) {
            if (summaryTaskEntry.taskName.length() <= maxTaskNameLength) continue;
            maxTaskNameLength = summaryTaskEntry.taskName.length();
        }
        return maxTaskNameLength + 3;
    }

    protected String getLineSeparator(int taskNameAndSeparatorLength) {
        StringBuilder sb = new StringBuilder();
        int headerLineLength = taskNameAndSeparatorLength + 8;
        for (int i = 0; i < headerLineLength; ++i) {
            sb.append('-');
        }
        sb.append('\n');
        return sb.toString();
    }

    protected void appendRootTaskResult(StringBuilder sb, MigrationData migrationData) {
        sb.append(" Migration Result: ").append((Object)migrationData.getRootTask().getResult().getStatus()).append('\n');
    }

    protected void appendTasks(StringBuilder sb, List<SummaryTaskEntry> summaryTaskEntries, int taskNameAndSeparatorLength) {
        for (SummaryTaskEntry summaryTaskEntry : summaryTaskEntries) {
            sb.append(summaryTaskEntry.taskName);
            int suffixLength = taskNameAndSeparatorLength - summaryTaskEntry.taskName.length();
            sb.append(' ');
            for (int i = 1; i < suffixLength; ++i) {
                sb.append('.');
            }
            sb.append(' ');
            sb.append((Object)summaryTaskEntry.taskResult.getStatus()).append('\n');
        }
    }

    private static class SummaryTaskEntry {
        private final String taskName;
        private final ServerMigrationTaskResult taskResult;

        private SummaryTaskEntry(String taskName, ServerMigrationTaskResult taskResult) {
            this.taskName = taskName;
            this.taskResult = taskResult;
        }
    }
}

