/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly13.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public abstract class UnsetDefaultHostResponseHeader<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "remove-response-header";
    private static final String SERVER_NAME = "default-server";
    private static final String HOST_NAME = "default-host";
    private static final String FILTER_REF = "filter-ref";
    private static final String CONFIGURATION = "configuration";
    private static final String FILTER = "filter";
    private static final String RESPONSE_HEADER = "response-header";
    private static final String HEADER_NAME = "header-name";
    protected final String filterName;
    protected final String headerName;

    public UnsetDefaultHostResponseHeader(String filterName, String headerName) {
        this.subtaskName("remove-response-header." + filterName);
        this.filterName = filterName;
        this.headerName = headerName;
    }

    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress configPathAddress = subsystemResource.getResourcePathAddress();
        PathAddress serverPathAddress = configPathAddress.append(new PathElement[]{PathElement.pathElement((String)"server", (String)SERVER_NAME)});
        if (!config.hasDefined(new String[]{"server", SERVER_NAME})) {
            context.getLogger().debugf("Skipping task, server '%s' not found in Undertow's config %s", (Object)serverPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode server = config.get(new String[]{"server", SERVER_NAME});
        PathAddress defaultHostPathAddress = serverPathAddress.append(new PathElement[]{PathElement.pathElement((String)"host", (String)HOST_NAME)});
        if (!server.hasDefined(new String[]{"host", HOST_NAME})) {
            context.getLogger().debugf("Skipping task, host '%s' not found in Undertow's config %s", (Object)defaultHostPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode filter = config.get(new String[]{CONFIGURATION, FILTER, RESPONSE_HEADER, this.filterName});
        if (!filter.isDefined()) {
            context.getLogger().debugf("Skipping task, filter name '%s' not found in Undertow's config %s", (Object)this.filterName, (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode filterHeaderName = filter.get(HEADER_NAME);
        if (!filterHeaderName.isDefined() || !filterHeaderName.asString().equals(this.headerName)) {
            context.getLogger().debugf("Skipping task, filter name '%s' found in Undertow's config %s but header name is %s, expected was %s", new Object[]{this.filterName, configPathAddress.toCLIStyleString(), filterHeaderName.asString(), this.headerName});
            return ServerMigrationTaskResult.SKIPPED;
        }
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        if (server.hasDefined(new String[]{"host", HOST_NAME, FILTER_REF, this.filterName})) {
            PathAddress filterRefPathAddress = defaultHostPathAddress.append(FILTER_REF, this.filterName);
            compositeOperationBuilder.addStep(Util.createRemoveOperation((PathAddress)filterRefPathAddress));
        }
        PathAddress responseHeaderPathAddress = configPathAddress.append(CONFIGURATION, FILTER).append(RESPONSE_HEADER, this.filterName);
        compositeOperationBuilder.addStep(Util.createRemoveOperation((PathAddress)responseHeaderPathAddress));
        subsystemResource.getServerConfiguration().executeManagementOperation(compositeOperationBuilder.build().getOperation());
        context.getLogger().debugf("Filter '%s', with header '%s', removed from Undertow's config %s", (Object)this.filterName, (Object)this.headerName, (Object)configPathAddress.toCLIStyleString());
        return ServerMigrationTaskResult.SUCCESS;
    }
}

