/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfiguration;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.SimpleComponentTask;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.core.util.xml.XMLFileFilter;
import org.jboss.migration.core.util.xml.XMLFiles;
import org.jboss.migration.wfly10.config.task.ServerConfigurationMigration;

public class RemoveUnsupportedSubsystems<S extends JBossServer<S>>
implements ServerConfigurationMigration.XMLConfigurationSubtaskFactory<JBossServerConfiguration<S>> {
    public static final String TASK_NAME = "subsystems.remove-unsupported-subsystems";
    public static final String SUBTASK_NAME = "subsystems.remove-unsupported-subsystems.remove-unsupported-subsystem";
    public static final String SUBTASK_NAME_ATTRIBUTE_NAMESPACE = "namespace";

    @Override
    public ServerMigrationTask getTask(JBossServerConfiguration<S> source, JBossServerConfiguration targetConfigurationPath) {
        return ((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(TASK_NAME)).skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet())).runnable(context -> {
            context.getLogger().debugf("Searching for subsystems not supported by the target server...", new Object[0]);
            this.run(source, targetConfigurationPath, context);
            if (!context.hasSucessfulSubtasks()) {
                context.getLogger().debugf("No unsupported subsystems found.", new Object[0]);
            }
            return ServerMigrationTaskResult.SUCCESS;
        })).build();
    }

    protected void run(JBossServerConfiguration<S> source, JBossServerConfiguration targetConfigurationPath, TaskContext context) {
        HashSet accepted = new HashSet(targetConfigurationPath.getServer().getExtensions().getExtensions().stream().flatMap(extension -> extension.getSubsystems().stream()).map(subsystem -> subsystem.getNamespaceWithoutVersion()).collect(Collectors.toList()));
        MigrationEnvironment environment = context.getMigrationEnvironment();
        accepted.addAll(environment.getPropertyAsList("subsystems.includes", Collections.emptyList()));
        accepted.removeAll(environment.getPropertyAsList("subsystems.excludes", Collections.emptyList()));
        HashSet removed = new HashSet();
        XMLFileFilter extensionsFilter = (startElement, xmlEventReader, xmlEventWriter, xmlEventFactory) -> {
            if (startElement.getName().getLocalPart().equals("subsystem")) {
                String namespaceURI = startElement.getName().getNamespaceURI();
                for (String namespaceWithoutVersion : accepted) {
                    if (namespaceURI == null || !namespaceURI.startsWith(namespaceWithoutVersion + ':')) continue;
                    return XMLFileFilter.Result.ADD;
                }
                ServerMigrationTask subtask = ((SimpleComponentTask.Builder)((SimpleComponentTask.Builder)new SimpleComponentTask.Builder().name(new ServerMigrationTaskName.Builder(SUBTASK_NAME).addAttribute(SUBTASK_NAME_ATTRIBUTE_NAMESPACE, namespaceURI).build())).runnable(subtaskContext -> {
                    subtaskContext.getLogger().debugf("Subsystem with namespace '%s' removed.", (Object)namespaceURI);
                    removed.add(namespaceURI);
                    return ServerMigrationTaskResult.SUCCESS;
                })).build();
                context.execute(subtask);
                return XMLFileFilter.Result.REMOVE;
            }
            return XMLFileFilter.Result.NOT_APPLICABLE;
        };
        XMLFiles.filter((Path)targetConfigurationPath.getPath(), (XMLFileFilter[])new XMLFileFilter[]{extensionsFilter});
        if (!removed.isEmpty()) {
            context.getLogger().infof("Unsupported subsystems removed: %s", removed);
        }
    }

    public static interface EnvironmentProperties {
        public static final String PREFIX = "subsystems.";
        public static final String INCLUDES = "subsystems.includes";
        public static final String EXCLUDES = "subsystems.excludes";
    }
}

