/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import java.util.HashSet;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class EnableHttp2<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "enable-http2";
    private static final String SERVER_NAME = "default-server";
    private static final String HTTP_LISTENER = "http-listener";
    private static final String HTTPS_LISTENER = "https-listener";
    private static final String ENABLE_HTTP2 = "enable-http2";

    public EnableHttp2() {
        this.subtaskName("enable-http2");
    }

    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress configPathAddress = subsystemResource.getResourcePathAddress();
        String configName = subsystemResource.getResourceAbsoluteName();
        PathAddress serverPathAddress = configPathAddress.append("server", SERVER_NAME);
        if (!config.hasDefined(new String[]{"server", SERVER_NAME})) {
            context.getLogger().debugf("Skipping task, server '%s' not found in Undertow's config %s", (Object)serverPathAddress.toCLIStyleString(), (Object)configName);
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode server = config.get(new String[]{"server", SERVER_NAME});
        HashSet<String> updatedHttpListeners = new HashSet<String>();
        if (server.hasDefined(HTTP_LISTENER)) {
            for (String listenerName : server.get(HTTP_LISTENER).keys()) {
                ModelNode listener = server.get(new String[]{HTTP_LISTENER, listenerName});
                if (listener.hasDefined("enable-http2") && listener.get("enable-http2").asBoolean()) continue;
                PathAddress listenerPathAddress = serverPathAddress.append(HTTP_LISTENER, listenerName);
                ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)listenerPathAddress);
                op.get("name").set("enable-http2");
                op.get("value").set(true);
                subsystemResource.getServerConfiguration().executeManagementOperation(op);
                context.getLogger().debugf("HTTP2 enabled for Undertow's HTTP Listener %s.", (Object)listenerPathAddress.toCLIStyleString());
                updatedHttpListeners.add(listenerName);
            }
        }
        HashSet<String> updatedHttpsListeners = new HashSet<String>();
        if (server.hasDefined(HTTPS_LISTENER)) {
            for (String listenerName : server.get(HTTPS_LISTENER).keys()) {
                ModelNode listener = server.get(new String[]{HTTPS_LISTENER, listenerName});
                if (listener.hasDefined("enable-http2") && listener.get("enable-http2").asBoolean()) continue;
                PathAddress listenerPathAddress = serverPathAddress.append(HTTPS_LISTENER, listenerName);
                ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)listenerPathAddress);
                op.get("name").set("enable-http2");
                op.get("value").set(true);
                subsystemResource.getServerConfiguration().executeManagementOperation(op);
                context.getLogger().debugf("HTTP2 enabled for Undertow's HTTPS Listener %s.", (Object)listenerPathAddress.toCLIStyleString());
                updatedHttpsListeners.add(listenerName);
            }
        }
        return new ServerMigrationTaskResult.Builder().success().addAttribute("http-listeners-updated", updatedHttpListeners).addAttribute("https-listeners-updated", updatedHttpsListeners).build();
    }
}

