/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.CompositeSubtasksBuilder;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.SocketBindingResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeSubtasks;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceLeafTask;

public class AddSocketBindingMulticastAddressExpressions<S>
extends ManageableServerConfigurationCompositeTask.Builder<S> {
    public static final String[] SOCKET_BINDINGS = new String[]{"modcluster"};

    public AddSocketBindingMulticastAddressExpressions() {
        this.name("socket-bindings.multicast-address.add-expressions");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.beforeRun(context -> context.getLogger().debugf("Adding socket binding's multicast address expressions...", new Object[0]));
        ManageableServerConfigurationCompositeSubtasks.Builder subtasks = new ManageableServerConfigurationCompositeSubtasks.Builder();
        for (String socketBinding : SOCKET_BINDINGS) {
            subtasks.subtask(SocketBindingResource.class, socketBinding, new AddSocketBindingMulticastAddressExpression(socketBinding));
        }
        this.subtasks((CompositeSubtasksBuilder)subtasks);
        this.afterRun(context -> {
            if (context.hasSucessfulSubtasks()) {
                context.getLogger().infof("Socket binding's multicast address expressions added.", new Object[0]);
            } else {
                context.getLogger().debugf("No socket binding's multicast address expressions added.", new Object[0]);
            }
        });
    }

    public static class AddSocketBindingMulticastAddressExpression<S>
    extends ManageableResourceLeafTask.Builder<S, SocketBindingResource> {
        protected AddSocketBindingMulticastAddressExpression(String resourceName) {
            this(resourceName, "jboss." + resourceName + ".multicast.address");
        }

        protected AddSocketBindingMulticastAddressExpression(String resourceName, String propertyName) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("socket-binding." + ((SocketBindingResource)parameters.getResource()).getResourceName() + ".multicast-address.add-expression").build());
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
            this.runBuilder(params -> context -> {
                SocketBindingResource socketBindingResource = (SocketBindingResource)params.getResource();
                String absoluteResourceName = socketBindingResource.getResourceAbsoluteName();
                ModelNode resourceConfig = socketBindingResource.getResourceConfiguration();
                if (!resourceConfig.hasDefined("multicast-address")) {
                    context.getLogger().debugf("Socket binding %s has no multicast address defined, task to add multicast address property skipped.", (Object)absoluteResourceName);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ModelNode resourceAttr = resourceConfig.get("multicast-address");
                if (resourceAttr.getType() == ModelType.EXPRESSION) {
                    context.getLogger().debugf("Socket binding %s unexpected multicast address value %s, task to add multicast address property skipped.", (Object)absoluteResourceName, (Object)resourceAttr.asExpression().getExpressionString());
                    return ServerMigrationTaskResult.SKIPPED;
                }
                ValueExpression valueExpression = new ValueExpression("${" + propertyName + ":" + resourceAttr.asString() + "}");
                PathAddress pathAddress = socketBindingResource.getResourcePathAddress();
                ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                writeAttrOp.get("name").set("multicast-address");
                writeAttrOp.get("value").set(valueExpression);
                socketBindingResource.getServerConfiguration().executeManagementOperation(writeAttrOp);
                context.getLogger().debugf("Socket binding %s multicast address value expression set as %s.", (Object)absoluteResourceName, (Object)valueExpression.getExpressionString());
                return ServerMigrationTaskResult.SUCCESS;
            });
        }
    }
}

