/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskExecution;

public class MigrationData {
    private final Server source;
    private final Server target;
    private final TaskExecution rootTask;
    private final List<TaskExecution> tasks;
    private final MigrationEnvironment migrationEnvironment;

    MigrationData(Server source, Server target, TaskExecution rootTask, MigrationEnvironment migrationEnvironment) {
        this.source = source;
        this.target = target;
        this.rootTask = rootTask;
        this.migrationEnvironment = migrationEnvironment;
        this.tasks = this.initTasks();
    }

    public Server getSource() {
        return this.source;
    }

    public Server getTarget() {
        return this.target;
    }

    public TaskExecution getRootTask() {
        return this.rootTask;
    }

    public MigrationEnvironment getServerMigrationEnvironment() {
        return this.rootTask.getServerMigrationContext().getMigrationEnvironment();
    }

    public MigrationEnvironment getMigrationEnvironment() {
        return this.migrationEnvironment;
    }

    public List<TaskExecution> getTasks() {
        return this.tasks;
    }

    public int getTaskCount(ServerMigrationTaskResult.Status status) {
        int count = 0;
        for (TaskExecution task : this.tasks) {
            if (task.getResult().getStatus() != status) continue;
            ++count;
        }
        return count;
    }

    private List<TaskExecution> initTasks() {
        ArrayList<TaskExecution> results = new ArrayList<TaskExecution>();
        results.add(this.getRootTask());
        this.addSubTasks(this.getRootTask(), results);
        return Collections.unmodifiableList(results);
    }

    private void addSubTasks(TaskExecution task, List<TaskExecution> tasks) {
        List<TaskExecution> subtasks = task.getSubtasks();
        if (subtasks != null) {
            for (TaskExecution subtask : subtasks) {
                tasks.add(subtask);
                this.addSubTasks(subtask, tasks);
            }
        }
    }
}

